/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.util;

public class ByteArrayBuffer {
    private byte[] buffer;
    int length;

    public ByteArrayBuffer(int initalsize) {
        this.buffer = new byte[initalsize];
        this.length = 0;
    }

    public void append(byte[] bytes) {
        this.append(bytes, 0, bytes.length);
    }

    public void append(byte[] bytes, int off, int len) {
        this.expandBuffer(this.length + len);
        System.arraycopy(bytes, off, this.buffer, this.length, len);
        this.length += len;
    }

    public byte[] getBytes() {
        byte[] copy = new byte[this.length];
        System.arraycopy(this.buffer, 0, copy, 0, this.length);
        return copy;
    }

    private void expandBuffer(int neededcapacity) {
        int newlength;
        if (this.buffer.length > neededcapacity) {
            return;
        }
        for (newlength = this.buffer.length * 2; newlength < neededcapacity; newlength *= 2) {
        }
        byte[] newbuffer = new byte[newlength];
        System.arraycopy(this.buffer, 0, newbuffer, 0, this.length);
        this.buffer = newbuffer;
    }
}

