/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import subzero.lib.util.ByteArrayBuffer;

public class IOUtils {
    public static byte[] getStreamAsByteArray(InputStream is) throws IOException {
        int read;
        byte[] bytes = new byte[1024];
        ByteArrayBuffer buffer = new ByteArrayBuffer(10240);
        while ((read = is.read(bytes)) != -1) {
            buffer.append(bytes, 0, read);
        }
        return buffer.getBytes();
    }

    public static void writeByteArrayToFile(byte[] bFile, String fileLocation) throws IOException {
        try {
            FileOutputStream fileOuputStream = new FileOutputStream(fileLocation);
            fileOuputStream.write(bFile);
            fileOuputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] getFileFromClassLoader(Class c, String path) throws IOException {
        InputStream is = c.getClassLoader().getResourceAsStream(path);
        return IOUtils.getStreamAsByteArray(is);
    }

    public static File getProjectRoot(Class c) {
        return IOUtils.getClasspathRoot(c).getParentFile();
    }

    public static File getClasspathRoot(Class c) {
        URL jarurl = c.getProtectionDomain().getCodeSource().getLocation();
        return new File(jarurl.getFile());
    }

    public static File getCodeSource(Class c) {
        URL jarurl = c.getProtectionDomain().getCodeSource().getLocation();
        return new File(jarurl.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortReady(String ip, int port) {
        Socket s = new Socket();
        try {
            InetSocketAddress endpoint = new InetSocketAddress(ip, port);
            s.connect(endpoint, 2000);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                s.close();
            }
            catch (Exception exception) {}
        }
    }

    public static boolean isReachable(String ip, int timeout) {
        try {
            InetAddress adr = InetAddress.getByName(ip);
            return adr.isReachable(timeout);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

