/*
 * Decompiled with CFR 0.152.
 */
package org.josql.functions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import org.josql.QueryExecutionException;
import org.josql.functions.AbstractFunctionHandler;
import org.josql.functions.FileMatch;
import org.josql.functions.regexp.RegExp;
import org.josql.functions.regexp.RegExpFactory;

public class StringFunctions
extends AbstractFunctionHandler {
    public static final String HANDLER_ID = "_internal_string";

    public boolean regexp(Object o, String re) throws QueryExecutionException {
        RegExp regexp = RegExpFactory.getDefaultInstance();
        if (regexp == null) {
            throw new QueryExecutionException("No default regular expression library available for: " + RegExpFactory.getDefaultInstanceName());
        }
        if (o == null) {
            return false;
        }
        String v = o.toString();
        return regexp.match(re, v);
    }

    public boolean regexp(Object o, String re, String instName) throws QueryExecutionException {
        RegExp regexp = RegExpFactory.getInstance(instName);
        if (regexp == null) {
            throw new QueryExecutionException("No regular expression library available for: " + instName);
        }
        if (o == null) {
            return false;
        }
        String v = o.toString();
        return regexp.match(re, v);
    }

    public List grep(File f, String s, boolean ignoreCase) throws QueryExecutionException {
        if (f == null || !f.exists() || f.isDirectory() || !f.canRead()) {
            return null;
        }
        ArrayList<FileMatch> retData = new ArrayList<FileMatch>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            String l = br.readLine();
            int lc = 1;
            String ss = s;
            if (ignoreCase) {
                ss = s.toLowerCase();
            }
            while (l != null) {
                int ind = -1;
                ind = ignoreCase ? l.toLowerCase().indexOf(ss) : l.indexOf(ss);
                if (ind != -1) {
                    retData.add(new FileMatch(f, lc, ind, s, l));
                }
                l = br.readLine();
                ++lc;
            }
            br.close();
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to read from file: " + f, e);
        }
        return retData;
    }

    public List rgrep(File f, String regexp, String instName) throws QueryExecutionException {
        RegExp reImpl = RegExpFactory.getInstance(instName);
        if (reImpl == null) {
            throw new QueryExecutionException("No default regular expression library available for: " + instName);
        }
        return this.rgrep(f, regexp, reImpl);
    }

    public List rgrep(File f, String regexp) throws QueryExecutionException {
        RegExp reImpl = RegExpFactory.getDefaultInstance();
        if (reImpl == null) {
            throw new QueryExecutionException("No default regular expression library available for: " + RegExpFactory.getDefaultInstanceName());
        }
        return this.rgrep(f, regexp, reImpl);
    }

    private final List rgrep(File f, String regexp, RegExp reImpl) throws QueryExecutionException {
        if (f == null || !f.exists() || f.isDirectory() || !f.canRead()) {
            return null;
        }
        ArrayList<FileMatch> retData = new ArrayList<FileMatch>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            String l = br.readLine();
            int lc = 1;
            while (l != null) {
                if (reImpl.match(regexp, l)) {
                    retData.add(new FileMatch(f, lc, -1, regexp, l));
                }
                l = br.readLine();
                ++lc;
            }
            br.close();
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to read from file: " + f, e);
        }
        return retData;
    }

    public List grep(File f, String s) throws QueryExecutionException {
        return this.grep(f, s, false);
    }

    public String trim(Object o, Object v) {
        if (o == null) {
            return null;
        }
        String os = o.toString();
        if (v == null) {
            return os.trim();
        }
        String vs = v.toString();
        if (os.endsWith(vs)) {
            os = os.substring(0, vs.length());
        }
        if (os.startsWith(vs)) {
            os = os.substring(vs.length());
        }
        return os;
    }

    public double lastIndexOf(Object o, Object i) {
        if (o == null) {
            return -1.0;
        }
        if (i == null) {
            return -1.0;
        }
        String os = o.toString();
        String is = i.toString();
        return os.lastIndexOf(is);
    }

    public String subStr(Object o, double f) {
        return this.subStr(o, f, -1.0);
    }

    public String subStr(Object o, double f, double t) {
        if (o == null) {
            return null;
        }
        int fi = (int)f;
        int ti = (int)t;
        String s = o.toString();
        if (fi < 0 || fi > s.length()) {
            return "";
        }
        if (ti < fi || ti > s.length()) {
            ti = -1;
        }
        if (ti == -1) {
            return s.substring(fi);
        }
        return s.substring(fi, ti);
    }

    public double length(Object o) {
        if (o == null) {
            return 0.0;
        }
        if (o instanceof String) {
            return ((String)o).length();
        }
        return o.toString().length();
    }
}

