/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import javax.annotation.Nonnull;
import mockit.coverage.CallPoint;
import mockit.coverage.data.CoverageData;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.lines.PerFileLineCoverage;
import mockit.coverage.testRedundancy.TestCoverage;

public final class TestRun {
    private static boolean terminated;

    private TestRun() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lineExecuted(int fileIndex, int line) {
        if (terminated) {
            return;
        }
        Class<TestRun> clazz = TestRun.class;
        synchronized (TestRun.class) {
            CoverageData coverageData = CoverageData.instance();
            PerFileLineCoverage fileData = coverageData.getFileData((int)fileIndex).lineCoverageInfo;
            CallPoint callPoint = null;
            if (coverageData.isWithCallPoints() && fileData.acceptsAdditionalCallPoints(line)) {
                callPoint = CallPoint.create(new Throwable());
            }
            int previousExecutionCount = fileData.registerExecution(line, callPoint);
            TestCoverage.INSTANCE.recordNewItemCoveredByTestIfApplicable(previousExecutionCount);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void branchExecuted(int fileIndex, int line, int branchIndex) {
        if (terminated) {
            return;
        }
        Class<TestRun> clazz = TestRun.class;
        synchronized (TestRun.class) {
            CoverageData coverageData = CoverageData.instance();
            PerFileLineCoverage fileData = coverageData.getFileData((int)fileIndex).lineCoverageInfo;
            if (fileData.hasValidBranch(line, branchIndex)) {
                CallPoint callPoint = null;
                if (coverageData.isWithCallPoints() && fileData.acceptsAdditionalCallPoints(line, branchIndex)) {
                    callPoint = CallPoint.create(new Throwable());
                }
                int previousExecutionCount = fileData.registerExecution(line, branchIndex, callPoint);
                TestCoverage.INSTANCE.recordNewItemCoveredByTestIfApplicable(previousExecutionCount);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nodeReached(@Nonnull String file, int firstLineInMethodBody, int node) {
        if (terminated) {
            return;
        }
        Class<TestRun> clazz = TestRun.class;
        synchronized (TestRun.class) {
            CoverageData coverageData = CoverageData.instance();
            FileCoverageData fileData = coverageData.getFileData(file);
            int previousExecutionCount = fileData.pathCoverageInfo.registerExecution(firstLineInMethodBody, node);
            TestCoverage.INSTANCE.recordNewItemCoveredByTestIfApplicable(previousExecutionCount);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fieldAssigned(@Nonnull String file, @Nonnull String classAndFieldNames) {
        if (terminated) {
            return;
        }
        Class<TestRun> clazz = TestRun.class;
        synchronized (TestRun.class) {
            CoverageData coverageData = CoverageData.instance();
            FileCoverageData fileData = coverageData.getFileData(file);
            fileData.dataCoverageInfo.registerAssignmentToStaticField(classAndFieldNames);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fieldRead(@Nonnull String file, @Nonnull String classAndFieldNames) {
        if (terminated) {
            return;
        }
        Class<TestRun> clazz = TestRun.class;
        synchronized (TestRun.class) {
            CoverageData coverageData = CoverageData.instance();
            FileCoverageData fileData = coverageData.getFileData(file);
            fileData.dataCoverageInfo.registerReadOfStaticField(classAndFieldNames);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fieldAssigned(@Nonnull Object instance, @Nonnull String file, @Nonnull String classAndFieldNames) {
        if (terminated) {
            return;
        }
        Class<TestRun> clazz = TestRun.class;
        synchronized (TestRun.class) {
            CoverageData coverageData = CoverageData.instance();
            FileCoverageData fileData = coverageData.getFileData(file);
            fileData.dataCoverageInfo.registerAssignmentToInstanceField(instance, classAndFieldNames);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fieldRead(@Nonnull Object instance, @Nonnull String file, @Nonnull String classAndFieldNames) {
        if (terminated) {
            return;
        }
        Class<TestRun> clazz = TestRun.class;
        synchronized (TestRun.class) {
            CoverageData coverageData = CoverageData.instance();
            FileCoverageData fileData = coverageData.getFileData(file);
            fileData.dataCoverageInfo.registerReadOfInstanceField(instance, classAndFieldNames);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    static void terminate() {
        terminated = true;
    }

    public static boolean isTerminated() {
        return terminated;
    }
}

