/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.internal;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.MissingInvocation;
import mockit.internal.UnexpectedInvocation;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.mocking.FieldTypeRedefinitions;
import mockit.internal.expectations.mocking.ParameterTypeRedefinitions;
import mockit.internal.expectations.mocking.TypeRedefinitions;
import mockit.internal.injection.TestedClassInstantiations;
import mockit.internal.state.SavePoint;
import mockit.internal.state.TestRun;
import mockit.internal.util.ParameterNameExtractor;
import mockit.internal.util.StackTrace;

public class TestRunnerDecorator {
    @Nullable
    private static SavePoint savePointForTestClass;
    @Nullable
    private static SavePoint savePointForTest;
    protected volatile boolean shouldPrepareForNextTest = true;

    protected TestRunnerDecorator() {
    }

    protected static void updateTestClassState(@Nullable Object target, @Nonnull Class<?> testClass) {
        try {
            TestRunnerDecorator.handleSwitchToNewTestClassIfApplicable(testClass);
            if (target != null) {
                TestRunnerDecorator.handleMockFieldsForWholeTestClass(target);
            }
        }
        catch (Error e) {
            try {
                TestRunnerDecorator.rollbackForTestClass();
            }
            catch (Error err) {
                StackTrace.filterStackTrace(err);
                throw err;
            }
            throw e;
        }
        catch (RuntimeException e) {
            TestRunnerDecorator.rollbackForTestClass();
            StackTrace.filterStackTrace(e);
            throw e;
        }
    }

    private static void handleSwitchToNewTestClassIfApplicable(@Nonnull Class<?> testClass) {
        Class<?> currentTestClass = TestRun.getCurrentTestClass();
        if (testClass != currentTestClass) {
            if (currentTestClass == null) {
                savePointForTestClass = new SavePoint();
            } else if (!currentTestClass.isAssignableFrom(testClass)) {
                TestRunnerDecorator.cleanUpMocksFromPreviousTestClass();
                savePointForTestClass = new SavePoint();
            }
            TestRun.setCurrentTestClass(testClass);
        }
    }

    public static void cleanUpMocksFromPreviousTestClass() {
        TestRunnerDecorator.cleanUpMocks(true);
    }

    protected static void cleanUpMocksFromPreviousTest() {
        TestRunnerDecorator.cleanUpMocks(false);
    }

    public static void cleanUpAllMocks() {
        TestRunnerDecorator.cleanUpMocks(true);
        TestRun.getMockClasses().discardStartupMocks();
    }

    private static void cleanUpMocks(boolean forTestClassAsWell) {
        TestRunnerDecorator.discardTestLevelMockedTypes();
        if (forTestClassAsWell) {
            TestRunnerDecorator.rollbackForTestClass();
        }
        TestRunnerDecorator.clearFieldTypeRedefinitions();
    }

    private static void rollbackForTestClass() {
        SavePoint savePoint = savePointForTestClass;
        if (savePoint != null) {
            savePoint.rollback();
            savePointForTestClass = null;
        }
    }

    protected static void clearFieldTypeRedefinitions() {
        FieldTypeRedefinitions fieldTypeRedefinitions = TestRun.getFieldTypeRedefinitions();
        if (fieldTypeRedefinitions != null) {
            ((TypeRedefinitions)fieldTypeRedefinitions).cleanUp();
            TestRun.setFieldTypeRedefinitions(null);
        }
    }

    protected static void prepareForNextTest() {
        if (savePointForTest == null) {
            savePointForTest = new SavePoint();
        }
        TestRun.prepareForNextTest();
    }

    protected static void discardTestLevelMockedTypes() {
        SavePoint savePoint = savePointForTest;
        if (savePoint != null) {
            savePoint.rollback();
            savePointForTest = null;
        }
    }

    protected static void handleMockFieldsForWholeTestClass(@Nonnull Object target) {
        Class<?> testClass = target.getClass();
        FieldTypeRedefinitions fieldTypeRedefinitions = TestRun.getFieldTypeRedefinitions();
        if (fieldTypeRedefinitions == null) {
            new ParameterNameExtractor().extractNames(testClass);
            fieldTypeRedefinitions = new FieldTypeRedefinitions(testClass);
            TestRun.setFieldTypeRedefinitions(fieldTypeRedefinitions);
            TestedClassInstantiations testedClassInstantiations = new TestedClassInstantiations();
            if (!testedClassInstantiations.findTestedAndInjectableFields(testClass)) {
                testedClassInstantiations = null;
            }
            TestRun.setTestedClassInstantiations(testedClassInstantiations);
        }
        if (target != TestRun.getCurrentTestInstance()) {
            fieldTypeRedefinitions.assignNewInstancesToMockFields(target);
        }
    }

    protected static void createInstancesForTestedFields(@Nonnull Object target, boolean beforeSetup) {
        TestedClassInstantiations testedClasses = TestRun.getTestedClassInstantiations();
        if (testedClasses != null) {
            TestRun.enterNoMockingZone();
            try {
                testedClasses.assignNewInstancesToTestedFields(target, beforeSetup);
            }
            finally {
                TestRun.exitNoMockingZone();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected static Object[] createInstancesForMockParameters(@Nonnull Method testMethod, @Nullable Object[] parameterValues) {
        if (testMethod.getParameterTypes().length == 0) {
            return null;
        }
        TestRun.enterNoMockingZone();
        try {
            ParameterTypeRedefinitions redefinitions = new ParameterTypeRedefinitions(testMethod, parameterValues);
            TestRun.getExecutingTest().setParameterRedefinitions(redefinitions);
            Object[] objectArray = redefinitions.getParameterValues();
            return objectArray;
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void concludeTestMethodExecution(@Nonnull SavePoint savePoint, @Nullable Throwable thrownByTest, boolean thrownAsExpected) throws Throwable {
        TestRun.enterNoMockingZone();
        Error expectationsFailure = RecordAndReplayExecution.endCurrentReplayIfAny();
        try {
            TestRunnerDecorator.clearTestedFieldsIfAny();
        }
        finally {
            savePoint.rollback();
            TestRun.exitNoMockingZone();
        }
        if (thrownByTest != null) {
            if (expectationsFailure == null || !thrownAsExpected || TestRunnerDecorator.isUnexpectedOrMissingInvocation(thrownByTest)) {
                throw thrownByTest;
            }
            Throwable expectationsFailureCause = expectationsFailure.getCause();
            if (expectationsFailureCause != null) {
                expectationsFailureCause.initCause(thrownByTest);
            }
        }
        if (expectationsFailure != null) {
            throw expectationsFailure;
        }
    }

    protected static void clearTestedFieldsIfAny() {
        TestedClassInstantiations testedClasses = TestRun.getTestedClassInstantiations();
        if (testedClasses != null) {
            testedClasses.clearTestedFields();
        }
    }

    private static boolean isUnexpectedOrMissingInvocation(@Nonnull Throwable error) {
        Class<?> errorType = error.getClass();
        return errorType == UnexpectedInvocation.class || errorType == MissingInvocation.class;
    }
}

