/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal;

import java.lang.instrument.ClassDefinition;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.ClassFile;
import mockit.internal.startup.Startup;
import mockit.internal.state.MockFixture;
import mockit.internal.state.TestRun;
import mockit.internal.util.GeneratedClasses;

public final class RedefinitionEngine {
    @Nonnull
    private Class<?> realClass;

    public RedefinitionEngine() {
    }

    public RedefinitionEngine(@Nonnull Class<?> realClass) {
        this.realClass = realClass;
    }

    public static void redefineClasses(ClassDefinition ... definitions) {
        Startup.redefineMethods(definitions);
        MockFixture mockFixture = TestRun.mockFixture();
        for (ClassDefinition def : definitions) {
            mockFixture.addRedefinedClass(def.getDefinitionClass(), def.getDefinitionClassFile());
        }
    }

    public void redefineMethodsWhileRegisteringTheClass(@Nonnull byte[] modifiedClassfile) {
        this.redefineMethods(modifiedClassfile);
        this.addToMapOfRedefinedClasses(null, modifiedClassfile);
        TestRun.mockFixture().registerMockedClass(this.realClass);
    }

    private void addToMapOfRedefinedClasses(@Nullable String mockClassInternalName, @Nonnull byte[] modifiedClassfile) {
        TestRun.mockFixture().addRedefinedClass(mockClassInternalName, this.realClass, modifiedClassfile);
    }

    private void redefineMethods(@Nonnull byte[] modifiedClassfile) {
        Startup.redefineMethods(this.realClass, modifiedClassfile);
    }

    public void redefineMethods(@Nonnull Map<Class<?>, byte[]> modifiedClassfiles) {
        ClassDefinition[] classDefs = new ClassDefinition[modifiedClassfiles.size()];
        int i = 0;
        for (Map.Entry<Class<?>, byte[]> classAndBytecode : modifiedClassfiles.entrySet()) {
            this.realClass = classAndBytecode.getKey();
            byte[] modifiedClassfile = classAndBytecode.getValue();
            classDefs[i++] = new ClassDefinition(this.realClass, modifiedClassfile);
            this.addToMapOfRedefinedClasses(null, modifiedClassfile);
        }
        Startup.redefineMethods(classDefs);
    }

    public void restoreDefinition(@Nonnull Class<?> aClass, @Nullable byte[] previousDefinition) {
        if (previousDefinition == null) {
            this.restoreOriginalDefinition(aClass);
        } else {
            this.restoreToDefinition(aClass, previousDefinition);
        }
    }

    public void restoreOriginalDefinition(@Nonnull Class<?> aClass) {
        if (!GeneratedClasses.isGeneratedImplementationClass(aClass)) {
            this.realClass = aClass;
            byte[] realClassFile = ClassFile.createReaderOrGetFromCache(aClass).b;
            this.redefineMethods(realClassFile);
        }
    }

    public void restoreToDefinition(@Nonnull Class<?> aClass, @Nonnull byte[] definitionToRestore) {
        this.realClass = aClass;
        this.redefineMethods(definitionToRestore);
    }
}

