/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.TestOnlyPhase;
import mockit.internal.expectations.VerifiedExpectation;
import mockit.internal.expectations.argumentMatching.ArgumentMatcher;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationArguments;
import mockit.internal.util.ClassLoad;

public abstract class BaseVerificationPhase
extends TestOnlyPhase {
    @Nonnull
    final List<Expectation> expectationsInReplayOrder;
    @Nonnull
    final List<Object> invocationInstancesInReplayOrder;
    @Nonnull
    final List<Object[]> invocationArgumentsInReplayOrder;
    private boolean allMockedInvocationsDuringReplayMustBeVerified;
    @Nullable
    private Object[] mockedTypesAndInstancesToFullyVerify;
    @Nonnull
    private final List<VerifiedExpectation> currentVerifiedExpectations;
    @Nullable
    private Expectation currentVerification;
    protected int replayIndex;
    @Nullable
    protected Error pendingError;
    @Nullable
    protected ExpectedInvocation matchingInvocationWithDifferentArgs;

    protected BaseVerificationPhase(@Nonnull RecordAndReplayExecution recordAndReplay, @Nonnull List<Expectation> expectationsInReplayOrder, @Nonnull List<Object> invocationInstancesInReplayOrder, @Nonnull List<Object[]> invocationArgumentsInReplayOrder) {
        super(recordAndReplay);
        this.expectationsInReplayOrder = expectationsInReplayOrder;
        this.invocationInstancesInReplayOrder = invocationInstancesInReplayOrder;
        this.invocationArgumentsInReplayOrder = invocationArgumentsInReplayOrder;
        this.currentVerifiedExpectations = new ArrayList<VerifiedExpectation>();
    }

    public final void setAllInvocationsMustBeVerified() {
        this.allMockedInvocationsDuringReplayMustBeVerified = true;
    }

    public final void setMockedTypesToFullyVerify(@Nonnull Object[] mockedTypesAndInstancesToFullyVerify) {
        this.mockedTypesAndInstancesToFullyVerify = mockedTypesAndInstancesToFullyVerify;
    }

    @Nonnull
    protected final Expectation expectationBeingVerified() {
        return this.currentVerification;
    }

    @Override
    @Nullable
    final Object handleInvocation(@Nullable Object mock, int mockAccess, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nullable String genericSignature, boolean withRealImpl, @Nonnull Object[] args) {
        if (this.pendingError != null) {
            this.recordAndReplay.setErrorThrown(this.pendingError);
            this.pendingError = null;
            return null;
        }
        this.matchInstance = mock != null && (this.recordAndReplay.executionState.isReplacementInstance(mock, mockNameAndDesc) || BaseVerificationPhase.isEnumElement(mock));
        ExpectedInvocation currentInvocation = new ExpectedInvocation(mock, mockAccess, mockClassDesc, mockNameAndDesc, this.matchInstance, genericSignature, args);
        currentInvocation.arguments.setMatchers(this.argMatchers);
        this.currentVerification = new Expectation(currentInvocation);
        this.currentExpectation = null;
        this.currentVerifiedExpectations.clear();
        List<ExpectedInvocation> matchingInvocationsWithDifferentArgs = this.findNonStrictExpectation(mock, mockClassDesc, mockNameAndDesc, args);
        this.argMatchers = null;
        if (this.recordAndReplay.getErrorThrown() != null) {
            return null;
        }
        if (this.currentExpectation == null) {
            this.pendingError = this.currentVerification.invocation.errorForMissingInvocation(matchingInvocationsWithDifferentArgs);
            this.currentExpectation = this.currentVerification;
        }
        return this.currentExpectation.invocation.getDefaultValueForReturnType();
    }

    @Nonnull
    abstract List<ExpectedInvocation> findNonStrictExpectation(@Nullable Object var1, @Nonnull String var2, @Nonnull String var3, @Nonnull Object[] var4);

    final boolean matches(@Nullable Object mock, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nonnull Object[] args, @Nonnull Expectation replayExpectation, @Nullable Object replayInstance, @Nonnull Object[] replayArgs) {
        ExpectedInvocation invocation = replayExpectation.invocation;
        boolean constructor = invocation.isConstructor();
        Map<Object, Object> replacementMap = this.getReplacementMap();
        this.matchingInvocationWithDifferentArgs = null;
        if (invocation.isMatch(mock, mockClassDesc, mockNameAndDesc, replacementMap)) {
            boolean matching;
            if (mock == null || invocation.instance == null) {
                matching = true;
            } else if (this.matchInstance) {
                matching = this.recordAndReplay.executionState.isEquivalentInstance(invocation.instance, mock);
            } else {
                boolean bl = matching = constructor || !this.recordAndReplay.executionState.areInDifferentEquivalenceSets(invocation.instance, mock);
            }
            if (matching) {
                this.matchingInvocationWithDifferentArgs = invocation;
                InvocationArguments invocationArguments = invocation.arguments;
                List<ArgumentMatcher<?>> originalMatchers = invocationArguments.getMatchers();
                Object[] originalArgs = invocationArguments.prepareForVerification(args, this.argMatchers);
                Map<Object, Object> instanceMap = this.getInstanceMap();
                boolean argumentsMatch = invocationArguments.isMatch(replayArgs, instanceMap);
                invocationArguments.setValuesAndMatchers(originalArgs, originalMatchers);
                if (argumentsMatch) {
                    if (constructor) {
                        instanceMap.put(replayInstance, mock);
                    }
                    this.addVerifiedExpectation(replayExpectation, replayArgs, this.argMatchers);
                    return true;
                }
            }
        }
        return false;
    }

    private void addVerifiedExpectation(@Nonnull Expectation expectation, @Nonnull Object[] args, @Nullable List<ArgumentMatcher<?>> matchers) {
        int i = this.expectationsInReplayOrder.indexOf(expectation);
        this.addVerifiedExpectation(new VerifiedExpectation(expectation, args, matchers, i));
    }

    void addVerifiedExpectation(@Nonnull VerifiedExpectation verifiedExpectation) {
        this.recordAndReplay.executionState.verifiedExpectations.add(verifiedExpectation);
        this.currentVerifiedExpectations.add(verifiedExpectation);
    }

    final void mapNewInstanceToReplacementIfApplicable(@Nullable Object mock) {
        if (mock != null && !this.matchInstance) {
            Object replacementInstance;
            assert (this.currentExpectation != null);
            ExpectedInvocation invocation = this.currentExpectation.invocation;
            if (invocation.isConstructor() && (replacementInstance = invocation.replacementInstance) != null) {
                this.getReplacementMap().put(mock, replacementInstance);
            }
        }
    }

    @Override
    public final void setMaxInvocationCount(int maxInvocations) {
        if (maxInvocations == 0 || this.pendingError == null) {
            super.setMaxInvocationCount(maxInvocations);
        }
    }

    @Nullable
    protected Error endVerification() {
        if (this.pendingError != null) {
            return this.pendingError;
        }
        if (this.allMockedInvocationsDuringReplayMustBeVerified) {
            return this.validateThatAllInvocationsWereVerified();
        }
        return null;
    }

    @Nullable
    private Error validateThatAllInvocationsWereVerified() {
        ArrayList<Expectation> notVerified = new ArrayList<Expectation>();
        for (int i = 0; i < this.expectationsInReplayOrder.size(); ++i) {
            Object[] replayArgs;
            Expectation replayExpectation = this.expectationsInReplayOrder.get(i);
            if (replayExpectation == null || !BaseVerificationPhase.isEligibleForFullVerification(replayExpectation) || this.wasVerified(replayExpectation, replayArgs = this.invocationArgumentsInReplayOrder.get(i))) continue;
            notVerified.add(replayExpectation);
        }
        if (!notVerified.isEmpty()) {
            if (this.mockedTypesAndInstancesToFullyVerify == null) {
                Expectation firstUnexpected = (Expectation)notVerified.get(0);
                return firstUnexpected.invocation.errorForUnexpectedInvocation();
            }
            return this.validateThatUnverifiedInvocationsAreAllowed(notVerified);
        }
        return null;
    }

    private static boolean isEligibleForFullVerification(@Nonnull Expectation replayExpectation) {
        return !replayExpectation.executedRealImplementation && replayExpectation.constraints.minInvocations <= 0;
    }

    private boolean wasVerified(@Nonnull Expectation replayExpectation, @Nonnull Object[] replayArgs) {
        InvocationArguments invokedArgs = replayExpectation.invocation.arguments;
        List<VerifiedExpectation> expectationsVerified = this.recordAndReplay.executionState.verifiedExpectations;
        for (int j = 0; j < expectationsVerified.size(); ++j) {
            VerifiedExpectation verified = expectationsVerified.get(j);
            if (verified.expectation != replayExpectation) continue;
            Object[] storedArgs = invokedArgs.prepareForVerification(verified.arguments, verified.argMatchers);
            boolean argumentsMatch = invokedArgs.isMatch(replayArgs, this.getInstanceMap());
            invokedArgs.setValuesWithNoMatchers(storedArgs);
            if (!argumentsMatch) continue;
            if (this.shouldDiscardInformationAboutVerifiedInvocationOnceUsed()) {
                expectationsVerified.remove(j);
            }
            return true;
        }
        invokedArgs.setValuesWithNoMatchers(replayArgs);
        return false;
    }

    boolean shouldDiscardInformationAboutVerifiedInvocationOnceUsed() {
        return false;
    }

    @Nullable
    private Error validateThatUnverifiedInvocationsAreAllowed(@Nonnull List<Expectation> unverified) {
        for (Expectation expectation : unverified) {
            ExpectedInvocation invocation = expectation.invocation;
            if (!this.isInvocationToBeVerified(invocation)) continue;
            return invocation.errorForUnexpectedInvocation();
        }
        return null;
    }

    private boolean isInvocationToBeVerified(@Nonnull ExpectedInvocation unverifiedInvocation) {
        String invokedClassName = unverifiedInvocation.getClassName();
        Object invokedInstance = unverifiedInvocation.instance;
        assert (this.mockedTypesAndInstancesToFullyVerify != null);
        for (Object mockedTypeOrInstance : this.mockedTypesAndInstancesToFullyVerify) {
            ClassLoader loader;
            Class invokedClass;
            Class mockedType;
            if (!(mockedTypeOrInstance instanceof Class ? invokedClassName.equals((mockedType = (Class)mockedTypeOrInstance).getName()) : (invokedInstance == null ? (invokedClass = ClassLoad.loadFromLoader(loader = mockedTypeOrInstance.getClass().getClassLoader(), invokedClassName)).isInstance(mockedTypeOrInstance) : (unverifiedInvocation.matchInstance ? mockedTypeOrInstance == invokedInstance : invokedInstance.getClass().isInstance(mockedTypeOrInstance))))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final Object getArgumentValueForCurrentVerification(int parameterIndex) {
        List<VerifiedExpectation> verifiedExpectations = this.recordAndReplay.executionState.verifiedExpectations;
        if (verifiedExpectations.isEmpty()) {
            return this.expectationBeingVerified().invocation.getArgumentValues()[parameterIndex];
        }
        VerifiedExpectation lastMatched = verifiedExpectations.get(verifiedExpectations.size() - 1);
        return lastMatched.arguments[parameterIndex];
    }

    public final void discardReplayedInvocations() {
        if (this.mockedTypesAndInstancesToFullyVerify == null) {
            this.expectationsInReplayOrder.clear();
            this.invocationArgumentsInReplayOrder.clear();
        } else {
            for (int i = this.expectationsInReplayOrder.size() - 1; i >= 0; --i) {
                Expectation expectation = this.expectationsInReplayOrder.get(i);
                if (!this.isInvocationToBeVerified(expectation.invocation)) continue;
                this.expectationsInReplayOrder.remove(i);
                this.invocationArgumentsInReplayOrder.remove(i);
            }
        }
    }

    @Nonnull
    public final <T> List<T> getNewInstancesMatchingVerifiedConstructorInvocation() {
        ArrayList<Object> newInstances = new ArrayList<Object>();
        for (VerifiedExpectation verifiedExpectation : this.currentVerifiedExpectations) {
            Object newInstance = verifiedExpectation.captureNewInstance();
            newInstances.add(newInstance);
        }
        return newInstances;
    }
}

