/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.argumentMatching;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.argumentMatching.ArgumentMatcher;
import mockit.internal.expectations.argumentMatching.ArgumentMismatch;
import mockit.internal.util.FieldReflection;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsSame;

public final class HamcrestAdapter
implements ArgumentMatcher<HamcrestAdapter> {
    @Nonnull
    private final Matcher<?> hamcrestMatcher;

    public HamcrestAdapter(@Nonnull Matcher<?> matcher) {
        this.hamcrestMatcher = matcher;
    }

    @Override
    public boolean same(@Nonnull HamcrestAdapter other) {
        return this.hamcrestMatcher == other.hamcrestMatcher;
    }

    @Override
    public boolean matches(@Nullable Object argValue) {
        return this.hamcrestMatcher.matches(argValue);
    }

    @Override
    public void writeMismatchPhrase(@Nonnull ArgumentMismatch argumentMismatch) {
        StringDescription strDescription = new StringDescription();
        this.hamcrestMatcher.describeTo((Description)strDescription);
        argumentMismatch.append(strDescription.toString());
    }

    @Nullable
    public Object getInnerValue() {
        Object innermostMatcher = this.getInnermostMatcher();
        return HamcrestAdapter.getArgumentValueFromMatcherIfAvailable(innermostMatcher);
    }

    @Nonnull
    private Object getInnermostMatcher() {
        Matcher innerMatcher = this.hamcrestMatcher;
        while (innerMatcher instanceof Is || innerMatcher instanceof IsNot) {
            innerMatcher = FieldReflection.getField(innerMatcher.getClass(), Matcher.class, innerMatcher);
        }
        assert (innerMatcher != null);
        return innerMatcher;
    }

    @Nullable
    private static Object getArgumentValueFromMatcherIfAvailable(@Nonnull Object argMatcher) {
        if (argMatcher instanceof IsEqual || argMatcher instanceof IsSame || "org.hamcrest.number.OrderingComparison".equals(argMatcher.getClass().getName())) {
            return FieldReflection.getField(argMatcher.getClass(), Object.class, argMatcher);
        }
        return null;
    }
}

