/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.BaseInvocation;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationArguments;
import mockit.internal.expectations.invocation.InvocationConstraints;
import mockit.internal.state.ExecutingTest;
import mockit.internal.state.TestRun;

final class DelegateInvocation
extends BaseInvocation {
    @Nonnull
    private final InvocationArguments invocationArguments;

    DelegateInvocation(@Nullable Object invokedInstance, @Nonnull Object[] invokedArguments, @Nonnull ExpectedInvocation expectedInvocation, @Nonnull InvocationConstraints constraints) {
        super(invokedInstance, invokedArguments, constraints.invocationCount);
        this.invocationArguments = expectedInvocation.arguments;
    }

    @Override
    @Nonnull
    protected Member findRealMember() {
        return this.invocationArguments.getRealMethodOrConstructor();
    }

    @Override
    public void prepareToProceed() {
        ExecutingTest executingTest = TestRun.getExecutingTest();
        if (this.getInvokedMember() instanceof Constructor) {
            executingTest.markAsProceedingIntoRealImplementation();
        } else {
            executingTest.markAsProceedingIntoRealImplementation(this);
        }
    }

    @Override
    public void cleanUpAfterProceed() {
        TestRun.getExecutingTest().clearProceedingState();
    }
}

