/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.MethodWriter;
import mockit.external.asm.Type;
import mockit.internal.BaseClassModifier;
import mockit.internal.expectations.ExecutionMode;

final class MockedTypeModifier {
    private MockedTypeModifier() {
    }

    static void generateDirectCallToHandler(@Nonnull MethodWriter mw, @Nonnull String className, int access, @Nonnull String name, @Nonnull String desc, @Nullable String genericSignature) {
        MockedTypeModifier.generateDirectCallToHandler(mw, className, access, name, desc, genericSignature, ExecutionMode.Regular);
    }

    static void generateDirectCallToHandler(@Nonnull MethodWriter mw, @Nonnull String className, int access, @Nonnull String name, @Nonnull String desc, @Nullable String genericSignature, @Nonnull ExecutionMode executionMode) {
        boolean isStatic = BaseClassModifier.generateCodeToPassThisOrNullIfStaticMethod(mw, access);
        mw.visitLdcInsn(access);
        mw.visitLdcInsn(className);
        mw.visitLdcInsn(name + desc);
        MockedTypeModifier.generateInstructionToLoadNullableString(mw, genericSignature);
        mw.visitLdcInsn(executionMode.ordinal());
        Type[] argTypes = Type.getArgumentTypes(desc);
        int argCount = argTypes.length;
        if (argCount == 0) {
            mw.visitInsn(1);
        } else {
            BaseClassModifier.generateCodeToCreateArrayOfObject(mw, argCount);
            BaseClassModifier.generateCodeToFillArrayWithParameterValues(mw, argTypes, 0, isStatic ? 0 : 1);
        }
        mw.visitMethodInsn(184, "mockit/internal/expectations/RecordAndReplayExecution", "recordOrReplay", "(Ljava/lang/Object;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;I[Ljava/lang/Object;)Ljava/lang/Object;", false);
    }

    private static void generateInstructionToLoadNullableString(@Nonnull MethodWriter mw, @Nullable String text) {
        if (text == null) {
            mw.visitInsn(1);
        } else {
            mw.visitLdcInsn(text);
        }
    }
}

