/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.enterprise.context.Conversation;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.sql.CommonDataSource;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionPointProvider;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.Injector;
import mockit.internal.injection.JPADependencies;
import mockit.internal.injection.ServletDependencies;
import mockit.internal.injection.TestConversation;
import mockit.internal.injection.TestDataSource;
import mockit.internal.injection.TestedClass;
import mockit.internal.injection.TestedObjectCreation;
import mockit.internal.util.ConstructorReflection;
import mockit.internal.util.GenericTypeReflection;
import mockit.internal.util.Utilities;

final class FullInjection {
    private static final int INVALID_TYPES = 25600;
    @Nonnull
    private final InjectionState injectionState;
    @Nonnull
    private final Field testedField;
    @Nullable
    private final ServletDependencies servletDependencies;
    @Nullable
    private final JPADependencies jpaDependencies;
    @Nonnull
    private Class<?> dependencyClass;
    @Nonnull
    private InjectionPointProvider injectionProvider;

    FullInjection(@Nonnull InjectionState injectionState, @Nonnull Field testedField) {
        this.injectionState = injectionState;
        this.testedField = testedField;
        this.servletDependencies = InjectionPoint.SERVLET_CLASS == null ? null : new ServletDependencies(injectionState);
        this.jpaDependencies = InjectionPoint.PERSISTENCE_UNIT_CLASS == null ? null : new JPADependencies(injectionState);
    }

    @Nullable
    Object reuseInstance(@Nonnull TestedClass testedClass, @Nonnull InjectionPointProvider injectionProvider, @Nullable String qualifiedName) {
        this.injectionProvider = injectionProvider;
        InjectionPoint injectionPoint = this.getInjectionPoint(testedClass.reflection, qualifiedName);
        Object dependency = this.injectionState.getInstantiatedDependency(testedClass, injectionProvider, injectionPoint);
        return dependency;
    }

    @Nonnull
    private InjectionPoint getInjectionPoint(@Nonnull GenericTypeReflection reflection, @Nullable String qualifiedName) {
        Type dependencyType = this.injectionProvider.getDeclaredType();
        if (dependencyType instanceof TypeVariable) {
            dependencyType = reflection.resolveTypeVariable((TypeVariable)dependencyType);
            this.dependencyClass = Utilities.getClassType(dependencyType);
        } else {
            this.dependencyClass = this.injectionProvider.getClassOfDeclaredType();
        }
        if (qualifiedName != null && !qualifiedName.isEmpty()) {
            return new InjectionPoint(this.dependencyClass, qualifiedName);
        }
        if (this.jpaDependencies != null && JPADependencies.isApplicable(this.dependencyClass)) {
            for (Annotation annotation : this.injectionProvider.getAnnotations()) {
                String id = this.jpaDependencies.getDependencyIdIfAvailable(annotation);
                if (id == null) continue;
                return new InjectionPoint(this.dependencyClass, id);
            }
        }
        return new InjectionPoint(dependencyType);
    }

    @Nullable
    Object createOrReuseInstance(@Nonnull Injector injector, @Nonnull InjectionPointProvider injectionProvider, @Nullable String qualifiedName) {
        TestedClass testedClass = injector.testedClass;
        this.setInjectionProvider(injectionProvider);
        InjectionPoint injectionPoint = this.getInjectionPoint(testedClass.reflection, qualifiedName);
        Object dependency = this.injectionState.getInstantiatedDependency(testedClass, injectionProvider, injectionPoint);
        if (dependency != null) {
            return dependency;
        }
        Class<?> typeToInject = this.dependencyClass;
        if (typeToInject == Logger.class) {
            return Logger.getLogger(testedClass.nameOfTestedClass);
        }
        if (!FullInjection.isInstantiableType(typeToInject)) {
            return null;
        }
        dependency = typeToInject.isInterface() ? this.createInstanceOfSupportedInterfaceIfApplicable(testedClass, injectionPoint) : this.createAndRegisterNewInstance(injector, injectionPoint);
        return dependency;
    }

    private void setInjectionProvider(@Nonnull InjectionPointProvider injectionProvider) {
        injectionProvider.parent = this.injectionProvider;
        this.injectionProvider = injectionProvider;
    }

    private static boolean isInstantiableType(@Nonnull Class<?> type) {
        if (type.isPrimitive() || type.isArray() || type.isAnnotation()) {
            return false;
        }
        if (!type.isInterface()) {
            int typeModifiers = type.getModifiers();
            if ((typeModifiers & 0x6400) != 0 || !Modifier.isStatic(typeModifiers) && type.isMemberClass()) {
                return false;
            }
            if (type.getClassLoader() == null) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private Object createInstanceOfSupportedInterfaceIfApplicable(@Nonnull TestedClass testedClass, @Nonnull InjectionPoint injectionPoint) {
        Class<?> typeToInject = this.dependencyClass;
        Object dependency = null;
        if (CommonDataSource.class.isAssignableFrom(typeToInject)) {
            dependency = this.createAndRegisterDataSource(testedClass, injectionPoint);
        } else if (InjectionPoint.INJECT_CLASS != null && typeToInject == Provider.class) {
            dependency = this.createProviderInstance();
        } else if (InjectionPoint.CONVERSATION_CLASS != null && typeToInject == Conversation.class) {
            dependency = this.createAndRegisterConversationInstance();
        } else if (this.servletDependencies != null && ServletDependencies.isApplicable(typeToInject)) {
            dependency = this.servletDependencies.createAndRegisterDependency(typeToInject);
        } else if (this.jpaDependencies != null && JPADependencies.isApplicable(typeToInject)) {
            dependency = this.jpaDependencies.createAndRegisterDependency(typeToInject, injectionPoint);
        }
        return dependency;
    }

    @Nullable
    private Object createAndRegisterDataSource(@Nonnull TestedClass testedClass, @Nonnull InjectionPoint injectionPoint) {
        TestDataSource dsCreation = new TestDataSource(injectionPoint);
        CommonDataSource dataSource = dsCreation.createIfDataSourceDefinitionAvailable(testedClass);
        if (dataSource != null) {
            this.injectionState.saveInstantiatedDependency(injectionPoint, dataSource);
        }
        return dataSource;
    }

    @Nonnull
    private Object createProviderInstance() {
        ParameterizedType genericType = (ParameterizedType)this.injectionProvider.getDeclaredType();
        final Class providedClass = (Class)genericType.getActualTypeArguments()[0];
        if (providedClass.isAnnotationPresent(Singleton.class)) {
            return new Provider<Object>(){
                private Object dependency;

                public synchronized Object get() {
                    if (this.dependency == null) {
                        this.dependency = FullInjection.this.createNewInstance(providedClass);
                    }
                    return this.dependency;
                }
            };
        }
        return new Provider<Object>(){

            public Object get() {
                Object dependency = FullInjection.this.createNewInstance(providedClass);
                return dependency;
            }
        };
    }

    @Nullable
    private Object createNewInstance(@Nonnull Class<?> dependencyClass) {
        if (dependencyClass.isInterface()) {
            return null;
        }
        if (dependencyClass.getClassLoader() == null) {
            return ConstructorReflection.newInstanceUsingDefaultConstructorIfAvailable(dependencyClass);
        }
        return new TestedObjectCreation(this.injectionState, this, dependencyClass).create();
    }

    @Nonnull
    private Object createAndRegisterConversationInstance() {
        TestConversation conversation = new TestConversation();
        InjectionPoint injectionPoint = new InjectionPoint((Type)((Object)Conversation.class));
        this.injectionState.saveInstantiatedDependency(injectionPoint, conversation);
        return conversation;
    }

    @Nullable
    private Object createAndRegisterNewInstance(@Nonnull Injector injector, @Nonnull InjectionPoint injectionPoint) {
        Object dependency = this.createNewInstance(this.dependencyClass);
        if (dependency != null) {
            if (injectionPoint.name == null) {
                injectionPoint = new InjectionPoint(injectionPoint.type, this.injectionProvider.getName());
            }
            this.registerNewInstance(injector, injectionPoint, dependency);
        }
        return dependency;
    }

    private void registerNewInstance(@Nonnull Injector injector, @Nonnull InjectionPoint injectionPoint, @Nonnull Object dependency) {
        Class<?> instantiatedClass = dependency.getClass();
        if (injector.testedClass.isClassFromSameModuleOrSystemAsTestedClass(instantiatedClass)) {
            injector.fillOutDependenciesRecursively(dependency);
            this.injectionState.lifecycleMethods.findLifecycleMethods(instantiatedClass);
            this.injectionState.lifecycleMethods.executeInitializationMethodsIfAny(instantiatedClass, dependency);
        }
        this.injectionState.saveInstantiatedDependency(injectionPoint, dependency);
    }

    public String toString() {
        String description = "@Tested field \"" + this.testedField.getType().getSimpleName() + ' ' + this.testedField.getName() + '\"';
        InjectionPointProvider parentInjectionProvider = this.injectionProvider.parent;
        if (parentInjectionProvider != null) {
            description = parentInjectionProvider + "\r\n  of " + description;
        }
        return description;
    }
}

