/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.enterprise.inject.Instance;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.servlet.Servlet;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.MethodReflection;
import mockit.internal.util.ParameterReflection;
import mockit.internal.util.Utilities;

final class InjectionPoint {
    @Nullable
    static final Class<? extends Annotation> INJECT_CLASS = ClassLoad.searchTypeInClasspath("javax.inject.Inject");
    @Nullable
    private static final Class<? extends Annotation> INSTANCE_CLASS = ClassLoad.searchTypeInClasspath("javax.enterprise.inject.Instance");
    @Nullable
    private static final Class<? extends Annotation> EJB_CLASS = ClassLoad.searchTypeInClasspath("javax.ejb.EJB");
    @Nullable
    static final Class<? extends Annotation> PERSISTENCE_UNIT_CLASS = ClassLoad.searchTypeInClasspath("javax.persistence.PersistenceUnit");
    @Nullable
    static final Class<?> SERVLET_CLASS = ClassLoad.searchTypeInClasspath("javax.servlet.Servlet");
    @Nullable
    static final Class<?> CONVERSATION_CLASS = ClassLoad.searchTypeInClasspath("javax.enterprise.context.Conversation");
    @Nonnull
    final Type type;
    @Nullable
    final String name;
    @Nullable
    private final String normalizedName;

    InjectionPoint(@Nonnull Type type) {
        this(type, null);
    }

    InjectionPoint(@Nonnull Type type, @Nullable String name) {
        this.type = type;
        this.name = name;
        this.normalizedName = name == null ? null : InjectionPoint.convertToLegalJavaIdentifierIfNeeded(name);
    }

    @Nonnull
    static String convertToLegalJavaIdentifierIfNeeded(@Nonnull String name) {
        if (name.indexOf(45) < 0 && name.indexOf(46) < 0) {
            return name;
        }
        StringBuilder identifier = new StringBuilder(name);
        for (int i = name.length() - 1; i >= 0; --i) {
            char c = identifier.charAt(i);
            if (c != '-' && c != '.') continue;
            identifier.deleteCharAt(i);
            c = identifier.charAt(i);
            identifier.setCharAt(i, Character.toUpperCase(c));
        }
        return identifier.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        InjectionPoint otherIP = (InjectionPoint)other;
        if (this.type instanceof TypeVariable || otherIP.type instanceof TypeVariable) {
            return false;
        }
        String thisName = this.normalizedName;
        String otherName = otherIP.normalizedName;
        if (thisName != null && !thisName.equals(otherName)) {
            return false;
        }
        Class<?> thisClass = Utilities.getClassType(this.type);
        Class<?> otherClass = Utilities.getClassType(otherIP.type);
        return thisClass.isAssignableFrom(otherClass);
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + (this.normalizedName != null ? this.normalizedName.hashCode() : 0);
    }

    static boolean isServlet(@Nonnull Class<?> aClass) {
        return SERVLET_CLASS != null && Servlet.class.isAssignableFrom(aClass);
    }

    @Nonnull
    static Object wrapInProviderIfNeeded(@Nonnull Type type, final @Nonnull Object value) {
        if (INJECT_CLASS != null && type instanceof ParameterizedType && !(value instanceof Provider)) {
            Type parameterizedType = ((ParameterizedType)type).getRawType();
            if (parameterizedType == Provider.class) {
                return new Provider<Object>(){

                    public Object get() {
                        return value;
                    }
                };
            }
            if (INSTANCE_CLASS != null && parameterizedType == Instance.class) {
                List values = (List)value;
                return new Listed(values);
            }
        }
        return value;
    }

    @Nonnull
    static KindOfInjectionPoint isAnnotated(@Nonnull AccessibleObject fieldOrConstructor) {
        Annotation[] annotations = fieldOrConstructor.getDeclaredAnnotations();
        if (annotations.length == 0) {
            return KindOfInjectionPoint.NotAnnotated;
        }
        if (INJECT_CLASS != null && InjectionPoint.isAnnotated(annotations, Inject.class)) {
            return KindOfInjectionPoint.Required;
        }
        KindOfInjectionPoint kind = InjectionPoint.isAutowired(annotations);
        if (kind != KindOfInjectionPoint.NotAnnotated || fieldOrConstructor instanceof Constructor) {
            return kind;
        }
        if (InjectionPoint.hasValue(annotations)) {
            return KindOfInjectionPoint.WithValue;
        }
        if (InjectionPoint.isRequired(annotations)) {
            return KindOfInjectionPoint.Required;
        }
        return KindOfInjectionPoint.NotAnnotated;
    }

    private static boolean isAnnotated(@Nonnull Annotation[] declaredAnnotations, @Nonnull Class<? extends Annotation> annotationOfInterest) {
        Annotation annotation = InjectionPoint.getAnnotation(declaredAnnotations, annotationOfInterest);
        return annotation != null;
    }

    @Nullable
    private static <A extends Annotation> A getAnnotation(@Nonnull Annotation[] declaredAnnotations, @Nonnull Class<A> annotationOfInterest) {
        for (Annotation declaredAnnotation : declaredAnnotations) {
            if (declaredAnnotation.annotationType() != annotationOfInterest) continue;
            return (A)declaredAnnotation;
        }
        return null;
    }

    @Nonnull
    private static KindOfInjectionPoint isAutowired(@Nonnull Annotation[] declaredAnnotations) {
        for (Annotation declaredAnnotation : declaredAnnotations) {
            Class<? extends Annotation> annotationType = declaredAnnotation.annotationType();
            if (!annotationType.getName().endsWith(".Autowired")) continue;
            Boolean required = (Boolean)MethodReflection.invokePublicIfAvailable(annotationType, declaredAnnotation, "required", ParameterReflection.NO_PARAMETERS, new Object[0]);
            return required != null && required != false ? KindOfInjectionPoint.Required : KindOfInjectionPoint.Optional;
        }
        return KindOfInjectionPoint.NotAnnotated;
    }

    private static boolean hasValue(@Nonnull Annotation[] declaredAnnotations) {
        for (Annotation declaredAnnotation : declaredAnnotations) {
            Class<? extends Annotation> annotationType = declaredAnnotation.annotationType();
            if (!annotationType.getName().endsWith(".Value")) continue;
            return true;
        }
        return false;
    }

    private static boolean isRequired(@Nonnull Annotation[] annotations) {
        return InjectionPoint.isAnnotated(annotations, Resource.class) || EJB_CLASS != null && InjectionPoint.isAnnotated(annotations, EJB.class) || PERSISTENCE_UNIT_CLASS != null && (InjectionPoint.isAnnotated(annotations, PersistenceContext.class) || InjectionPoint.isAnnotated(annotations, PersistenceUnit.class));
    }

    @Nullable
    static Object getValueFromAnnotation(@Nonnull Field field) {
        String value = null;
        for (Annotation declaredAnnotation : field.getDeclaredAnnotations()) {
            Class<? extends Annotation> annotationType = declaredAnnotation.annotationType();
            if (!annotationType.getName().endsWith(".Value")) continue;
            value = (String)MethodReflection.invokePublicIfAvailable(annotationType, declaredAnnotation, "value", ParameterReflection.NO_PARAMETERS, new Object[0]);
            break;
        }
        Object convertedValue = Utilities.convertFromString(field.getType(), value);
        return convertedValue;
    }

    @Nonnull
    static Type getTypeOfInjectionPointFromVarargsParameter(@Nonnull Type parameterType) {
        if (parameterType instanceof Class) {
            return ((Class)parameterType).getComponentType();
        }
        return ((GenericArrayType)parameterType).getGenericComponentType();
    }

    @Nullable
    static String getQualifiedName(@Nonnull Annotation[] annotationsOnInjectionPoint) {
        for (Annotation annotation : annotationsOnInjectionPoint) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            String annotationName = annotationType.getName();
            if ("javax.annotation.Resource javax.ejb.EJB".contains(annotationName)) {
                String name = MethodReflection.readAnnotationAttribute(annotation, "name");
                if (name.isEmpty()) {
                    name = MethodReflection.readAnnotationAttribute(annotation, "lookup");
                    name = InjectionPoint.getNameFromJNDILookup(name);
                }
                return name;
            }
            if (!"javax.inject.Named".equals(annotationName) && !annotationName.endsWith(".Qualifier")) continue;
            String qualifiedName = MethodReflection.readAnnotationAttribute(annotation, "value");
            return qualifiedName;
        }
        return null;
    }

    @Nonnull
    static String getNameFromJNDILookup(@Nonnull String jndiLookup) {
        int p = jndiLookup.lastIndexOf(47);
        if (p >= 0) {
            jndiLookup = jndiLookup.substring(p + 1);
        }
        return jndiLookup;
    }

    private static final class Listed
    implements Instance<Object> {
        @Nonnull
        private final List<Object> instances;

        Listed(@Nonnull List<Object> instances) {
            this.instances = instances;
        }

        public Instance<Object> select(Annotation ... annotations) {
            return null;
        }

        public <U> Instance<U> select(Class<U> uClass, Annotation ... annotations) {
            return null;
        }

        public <U> Instance<U> select(TypeLiteral<U> tl, Annotation ... annotations) {
            return null;
        }

        public boolean isUnsatisfied() {
            return false;
        }

        public boolean isAmbiguous() {
            return false;
        }

        public void destroy(Object instance) {
        }

        public Iterator<Object> iterator() {
            return this.instances.iterator();
        }

        public Object get() {
            throw new RuntimeException("Unexpected");
        }
    }

    static enum KindOfInjectionPoint {
        NotAnnotated,
        Required,
        Optional,
        WithValue;

    }
}

