/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import javax.servlet.ServletConfig;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.ParameterTypeRedefinitions;
import mockit.internal.injection.BeanExporter;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionPointProvider;
import mockit.internal.injection.LifecycleMethods;
import mockit.internal.injection.MultiValuedProvider;
import mockit.internal.injection.TestedClass;
import mockit.internal.state.TestRun;
import mockit.internal.util.GenericTypeReflection;
import mockit.internal.util.Utilities;

final class InjectionState
implements BeanExporter {
    @Nonnull
    private static final Map<InjectionPoint, Object> globalDependencies = new ConcurrentHashMap<InjectionPoint, Object>(2);
    @Nonnull
    private final Map<InjectionPoint, Object> testedObjects = new HashMap<InjectionPoint, Object>();
    @Nonnull
    private final Map<InjectionPoint, Object> instantiatedDependencies = new HashMap<InjectionPoint, Object>();
    @Nonnull
    private List<MockedType> injectables = Collections.emptyList();
    @Nonnull
    private List<InjectionPointProvider> consumedInjectables = new ArrayList<InjectionPointProvider>();
    @Nonnull
    final LifecycleMethods lifecycleMethods = new LifecycleMethods();
    private GenericTypeReflection testedTypeReflection;
    private Object currentTestClassInstance;
    private Type typeOfInjectionPoint;

    InjectionState() {
    }

    void buildListsOfInjectables(@Nonnull Object testClassInstance, @Nonnull List<MockedType> injectables) {
        this.currentTestClassInstance = testClassInstance;
        this.injectables = new ArrayList<MockedType>(injectables);
        ParameterTypeRedefinitions paramTypeRedefs = TestRun.getExecutingTest().getParameterRedefinitions();
        if (paramTypeRedefs != null) {
            this.injectables.addAll(paramTypeRedefs.getInjectableParameters());
        }
        this.getServletConfigForInitMethodsIfAny(testClassInstance);
    }

    private void getServletConfigForInitMethodsIfAny(@Nonnull Object testClassInstance) {
        if (InjectionPoint.SERVLET_CLASS != null) {
            for (InjectionPointProvider injectionPointProvider : this.injectables) {
                if (injectionPointProvider.getDeclaredType() != ServletConfig.class) continue;
                this.lifecycleMethods.servletConfig = injectionPointProvider.getValue(testClassInstance);
                break;
            }
        }
    }

    Object getCurrentTestClassInstance() {
        return this.currentTestClassInstance;
    }

    void setTestedTypeReflection(@Nonnull GenericTypeReflection reflection) {
        this.testedTypeReflection = reflection;
    }

    void setTypeOfInjectionPoint(@Nonnull Type typeOfInjectionPoint) {
        this.typeOfInjectionPoint = typeOfInjectionPoint;
    }

    private boolean hasSameTypeAsInjectionPoint(@Nonnull InjectionPointProvider injectable) {
        Type declaredType = injectable.getDeclaredType();
        return this.isSameTypeAsInjectionPoint(declaredType);
    }

    boolean isSameTypeAsInjectionPoint(@Nonnull Type injectableType) {
        ParameterizedType parameterizedType;
        Class classOfInjectionPoint;
        if (this.testedTypeReflection.areMatchingTypes(this.typeOfInjectionPoint, injectableType)) {
            return true;
        }
        if (this.typeOfInjectionPoint instanceof ParameterizedType && (Iterable.class.isAssignableFrom(classOfInjectionPoint = (Class)(parameterizedType = (ParameterizedType)this.typeOfInjectionPoint).getRawType()) || InjectionPoint.INJECT_CLASS != null && Provider.class.isAssignableFrom(classOfInjectionPoint))) {
            Type providedType = parameterizedType.getActualTypeArguments()[0];
            if (providedType.equals(injectableType)) {
                return true;
            }
            Class<?> injectableClass = Utilities.getClassType(injectableType);
            Class<?> providedClass = Utilities.getClassType(providedType);
            return providedClass.isAssignableFrom(injectableClass);
        }
        return false;
    }

    @Nullable
    MockedType findNextInjectableForInjectionPoint() {
        for (MockedType injectable : this.injectables) {
            if (!this.hasSameTypeAsInjectionPoint(injectable) || this.consumedInjectables.contains(injectable)) continue;
            return injectable;
        }
        return null;
    }

    @Nonnull
    List<MockedType> findInjectablesByType() {
        ArrayList<MockedType> found = new ArrayList<MockedType>();
        for (MockedType injectable : this.injectables) {
            if (!this.hasSameTypeAsInjectionPoint(injectable) || this.consumedInjectables.contains(injectable)) continue;
            found.add(injectable);
        }
        return found;
    }

    @Nullable
    InjectionPointProvider getProviderByTypeAndOptionallyName(@Nonnull String nameOfInjectionPoint) {
        Type elementTypeOfIterable = InjectionState.getElementTypeIfIterable(this.typeOfInjectionPoint);
        if (elementTypeOfIterable != null) {
            return this.findInjectablesByTypeOnly(elementTypeOfIterable);
        }
        return this.findInjectableByTypeAndOptionallyName(nameOfInjectionPoint);
    }

    @Nullable
    Object getValueForParameterFromTestedField(@Nonnull String nameOfInjectionPoint) {
        InjectionPoint injectionPoint = new InjectionPoint(this.typeOfInjectionPoint, nameOfInjectionPoint);
        return this.testedObjects.get(injectionPoint);
    }

    @Nullable
    private static Type getElementTypeIfIterable(@Nonnull Type injectableType) {
        ParameterizedType parameterizedType;
        Class classOfInjectionPoint;
        if (injectableType instanceof ParameterizedType && Iterable.class.isAssignableFrom(classOfInjectionPoint = (Class)(parameterizedType = (ParameterizedType)injectableType).getRawType())) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    @Nullable
    private InjectionPointProvider findInjectablesByTypeOnly(@Nonnull Type elementType) {
        MultiValuedProvider found = null;
        for (MockedType injectable : this.injectables) {
            Type injectableType = injectable.getDeclaredType();
            Type elementTypeOfIterable = InjectionState.getElementTypeIfIterable(injectableType);
            if (elementTypeOfIterable != null && this.testedTypeReflection.areMatchingTypes(elementType, elementTypeOfIterable)) {
                return injectable;
            }
            if (!this.isSameTypeAsInjectionPoint(injectableType)) continue;
            if (found == null) {
                found = new MultiValuedProvider(elementType);
            }
            found.addInjectable(injectable);
        }
        return found;
    }

    @Nullable
    private MockedType findInjectableByTypeAndOptionallyName(@Nonnull String nameOfInjectionPoint) {
        MockedType found = null;
        for (MockedType injectable : this.injectables) {
            if (!this.hasSameTypeAsInjectionPoint(injectable)) continue;
            if (nameOfInjectionPoint.equals(injectable.getName())) {
                return injectable;
            }
            if (found != null) continue;
            found = injectable;
        }
        return found;
    }

    @Nullable
    MockedType findInjectableByTypeAndName(@Nonnull String nameOfInjectionPoint) {
        for (MockedType injectable : this.injectables) {
            if (!this.hasSameTypeAsInjectionPoint(injectable) || !nameOfInjectionPoint.equals(injectable.getName())) continue;
            return injectable;
        }
        return null;
    }

    @Nullable
    Object getValueToInject(@Nonnull InjectionPointProvider injectable) {
        if (this.consumedInjectables.contains(injectable)) {
            return null;
        }
        Object value = injectable.getValue(this.currentTestClassInstance);
        if (value != null) {
            this.consumedInjectables.add(injectable);
        }
        return value;
    }

    void resetConsumedInjectables() {
        this.consumedInjectables.clear();
    }

    @Nonnull
    List<InjectionPointProvider> saveConsumedInjectables() {
        List<InjectionPointProvider> previousConsumedInjectables = this.consumedInjectables;
        this.consumedInjectables = new ArrayList<InjectionPointProvider>();
        return previousConsumedInjectables;
    }

    void restoreConsumedInjectables(@Nonnull List<InjectionPointProvider> previousConsumedInjectables) {
        this.consumedInjectables = previousConsumedInjectables;
    }

    void saveTestedObject(@Nonnull InjectionPoint key, @Nonnull Object testedObject) {
        this.testedObjects.put(key, testedObject);
    }

    @Nullable
    Object getTestedInstance(@Nonnull Type testedType, @Nonnull String nameOfInjectionPoint) {
        InjectionPoint injectionPoint = new InjectionPoint(testedType, nameOfInjectionPoint);
        Object dependency = this.instantiatedDependencies.get(injectionPoint);
        if (dependency == null && (dependency = this.instantiatedDependencies.get(injectionPoint = new InjectionPoint(testedType))) == null) {
            dependency = this.findMatchingObject(this.instantiatedDependencies, null, injectionPoint);
        }
        return dependency;
    }

    @Nullable
    <D> D getGlobalDependency(@Nonnull InjectionPoint key) {
        return (D)globalDependencies.get(key);
    }

    @Nullable
    Object getInstantiatedDependency(@Nonnull TestedClass testedClass, @Nonnull InjectionPointProvider injectionProvider, @Nonnull InjectionPoint dependencyKey) {
        Object dependency = this.testedObjects.get(dependencyKey);
        if (dependency == null && (dependency = this.findMatchingObject(this.testedObjects, testedClass.reflection, dependencyKey)) == null && (dependency = this.instantiatedDependencies.get(dependencyKey)) == null && (dependency = this.findMatchingObject(this.instantiatedDependencies, null, dependencyKey)) == null) {
            dependency = this.findMatchingObject(globalDependencies, null, dependencyKey);
        }
        return dependency;
    }

    @Nullable
    private Object findMatchingObject(@Nonnull Map<InjectionPoint, Object> availableObjects, @Nullable GenericTypeReflection reflection, @Nonnull InjectionPoint injectionPoint) {
        Type dependencyType = injectionPoint.type;
        for (Map.Entry<InjectionPoint, Object> injectionPointAndObject : availableObjects.entrySet()) {
            InjectionPoint dependencyIP = injectionPointAndObject.getKey();
            Object dependencyObject = injectionPointAndObject.getValue();
            if (!injectionPoint.equals(dependencyIP) && (reflection == null || !reflection.areMatchingTypes(dependencyType, dependencyIP.type))) continue;
            return dependencyObject;
        }
        return null;
    }

    void saveInstantiatedDependency(@Nonnull InjectionPoint dependencyKey, @Nonnull Object dependency) {
        this.instantiatedDependencies.put(dependencyKey, dependency);
    }

    void saveGlobalDependency(@Nonnull InjectionPoint dependencyKey, @Nonnull Object dependency) {
        globalDependencies.put(dependencyKey, dependency);
    }

    void clearTestedObjectsAndInstantiatedDependencies() {
        this.testedObjects.clear();
        this.instantiatedDependencies.clear();
    }

    @Override
    public Object getBean(@Nonnull String name) {
        for (InjectionPointProvider injectionPointProvider : this.injectables) {
            if (!name.equals(injectionPointProvider.getName())) continue;
            return injectionPointProvider.getValue(this.currentTestClassInstance);
        }
        Object bean = this.findByName(this.testedObjects, name);
        if (bean == null && (bean = this.findByName(this.instantiatedDependencies, name)) == null) {
            bean = this.findByName(globalDependencies, name);
        }
        return bean;
    }

    @Nullable
    private Object findByName(@Nonnull Map<InjectionPoint, Object> injectionPointsAndObjects, @Nonnull String name) {
        for (Map.Entry<InjectionPoint, Object> injectionPointAndObject : injectionPointsAndObjects.entrySet()) {
            InjectionPoint injectionPoint = injectionPointAndObject.getKey();
            if (!name.equals(injectionPoint.name)) continue;
            return injectionPointAndObject.getValue();
        }
        return null;
    }
}

