/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionState;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class JPADependencies {
    @Nonnull
    private final InjectionState injectionState;
    @Nullable
    private String defaultPersistenceUnitName;

    static boolean isApplicable(@Nonnull Class<?> dependencyType) {
        return dependencyType == EntityManager.class || dependencyType == EntityManagerFactory.class;
    }

    JPADependencies(@Nonnull InjectionState injectionState) {
        this.injectionState = injectionState;
    }

    @Nullable
    String getDependencyIdIfAvailable(@Nonnull Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        String unitName = null;
        if (annotationType == PersistenceUnit.class) {
            unitName = ((PersistenceUnit)annotation).unitName();
        } else if (annotationType == PersistenceContext.class) {
            unitName = ((PersistenceContext)annotation).unitName();
        }
        return unitName == null ? null : this.getNameOfPersistentUnit(unitName);
    }

    @Nonnull
    private String getNameOfPersistentUnit(@Nullable String injectionPointName) {
        return injectionPointName != null && !injectionPointName.isEmpty() ? injectionPointName : this.discoverNameOfDefaultPersistenceUnit();
    }

    @Nonnull
    private String discoverNameOfDefaultPersistenceUnit() {
        if (this.defaultPersistenceUnitName != null) {
            return this.defaultPersistenceUnitName;
        }
        this.defaultPersistenceUnitName = "<unknown>";
        InputStream xmlFile = this.getClass().getResourceAsStream("/META-INF/persistence.xml");
        if (xmlFile != null) {
            try {
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse(xmlFile, new DefaultHandler(){

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) {
                        if ("persistence-unit".equals(qName)) {
                            JPADependencies.this.defaultPersistenceUnitName = attributes.getValue("name");
                        }
                    }
                });
                xmlFile.close();
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.defaultPersistenceUnitName;
    }

    @Nonnull
    Object createAndRegisterDependency(@Nonnull Class<?> dependencyType, @Nonnull InjectionPoint dependencyKey) {
        if (dependencyType == EntityManagerFactory.class) {
            InjectionPoint injectionPoint = this.createFactoryInjectionPoint(dependencyKey);
            EntityManagerFactory emFactory = this.createAndRegisterEntityManagerFactory(injectionPoint);
            return emFactory;
        }
        return this.createAndRegisterEntityManager(dependencyKey);
    }

    @Nonnull
    private InjectionPoint createFactoryInjectionPoint(@Nonnull InjectionPoint injectionPoint) {
        String persistenceUnitName = this.getNameOfPersistentUnit(injectionPoint.name);
        return new InjectionPoint((Type)((Object)EntityManagerFactory.class), persistenceUnitName);
    }

    @Nonnull
    private EntityManagerFactory createAndRegisterEntityManagerFactory(@Nonnull InjectionPoint injectionPoint) {
        String persistenceUnitName = injectionPoint.name;
        EntityManagerFactory emFactory = Persistence.createEntityManagerFactory((String)persistenceUnitName);
        this.injectionState.saveGlobalDependency(injectionPoint, emFactory);
        return emFactory;
    }

    @Nonnull
    private EntityManager createAndRegisterEntityManager(@Nonnull InjectionPoint injectionPoint) {
        InjectionPoint emFactoryKey = this.createFactoryInjectionPoint(injectionPoint);
        EntityManagerFactory emFactory = (EntityManagerFactory)this.injectionState.getGlobalDependency(emFactoryKey);
        if (emFactory == null) {
            emFactory = this.createAndRegisterEntityManagerFactory(emFactoryKey);
        }
        EntityManager entityManager = emFactory.createEntityManager();
        this.injectionState.saveInstantiatedDependency(injectionPoint, entityManager);
        return entityManager;
    }
}

