/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.io.File;
import java.lang.reflect.Type;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.util.GenericTypeReflection;

final class TestedClass {
    @Nonnull
    final Type declaredType;
    @Nonnull
    final Class<?> targetClass;
    @Nonnull
    final GenericTypeReflection reflection;
    @Nonnull
    final ProtectionDomain protectionDomainOfTestedClass;
    @Nullable
    final String codeLocationParentPath;
    @Nonnull
    final String nameOfTestedClass;

    TestedClass(@Nonnull Type declaredType, @Nonnull Class<?> targetClass) {
        this.declaredType = declaredType;
        this.targetClass = targetClass;
        this.reflection = new GenericTypeReflection(targetClass, declaredType, false);
        this.protectionDomainOfTestedClass = targetClass.getProtectionDomain();
        CodeSource codeSource = this.protectionDomainOfTestedClass.getCodeSource();
        this.codeLocationParentPath = codeSource == null || codeSource.getLocation() == null ? null : new File(codeSource.getLocation().getPath()).getParent();
        this.nameOfTestedClass = targetClass.getName();
    }

    boolean isClassFromSameModuleOrSystemAsTestedClass(@Nonnull Class<?> anotherClass) {
        String anotherClassPath;
        String anotherClassParentPath;
        if (anotherClass.getClassLoader() == null) {
            return false;
        }
        ProtectionDomain anotherProtectionDomain = anotherClass.getProtectionDomain();
        if (anotherProtectionDomain == null) {
            return false;
        }
        if (anotherProtectionDomain == this.protectionDomainOfTestedClass) {
            return true;
        }
        CodeSource anotherCodeSource = anotherProtectionDomain.getCodeSource();
        if (anotherCodeSource == null || anotherCodeSource.getLocation() == null) {
            return false;
        }
        if (this.codeLocationParentPath != null && (anotherClassParentPath = new File(anotherClassPath = anotherCodeSource.getLocation().getPath()).getParent()).equals(this.codeLocationParentPath)) {
            return true;
        }
        return this.isInSameSubpackageAsTestedClass(anotherClass);
    }

    boolean isInSameSubpackageAsTestedClass(@Nonnull Class<?> anotherClass) {
        boolean eitherClassDirectlyInFirstPackageLevel;
        int p2;
        boolean differentPackages;
        String nameOfAnotherClass = anotherClass.getName();
        int p1 = nameOfAnotherClass.indexOf(46);
        boolean bl = differentPackages = p1 != (p2 = this.nameOfTestedClass.indexOf(46)) || p1 == -1;
        if (differentPackages) {
            return false;
        }
        p1 = nameOfAnotherClass.indexOf(46, p1 + 1);
        p2 = this.nameOfTestedClass.indexOf(46, p2 + 1);
        boolean bl2 = eitherClassDirectlyInFirstPackageLevel = p1 == -1 || p2 == -1;
        if (eitherClassDirectlyInFirstPackageLevel) {
            return true;
        }
        boolean differentSubpackages = p1 != p2;
        return !differentSubpackages && nameOfAnotherClass.substring(0, p1).equals(this.nameOfTestedClass.substring(0, p2));
    }
}

