/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassVisitor;
import mockit.internal.classGeneration.ImplementationClass;
import mockit.internal.expectations.mocking.SubclassGenerationModifier;
import mockit.internal.injection.ConstructorInjection;
import mockit.internal.injection.ConstructorSearch;
import mockit.internal.injection.FullInjection;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.TestedClass;
import mockit.internal.state.TestRun;

final class TestedObjectCreation {
    @Nonnull
    private final InjectionState injectionState;
    @Nullable
    private final FullInjection fullInjection;
    @Nonnull
    private final Class<?> actualTestedClass;
    @Nonnull
    final TestedClass testedClass;

    TestedObjectCreation(@Nonnull InjectionState injectionState, @Nullable FullInjection fullInjection, @Nonnull Field testedField) {
        this.injectionState = injectionState;
        this.fullInjection = fullInjection;
        Class<?> declaredTestedClass = testedField.getType();
        Type declaredType = testedField.getGenericType();
        this.actualTestedClass = Modifier.isAbstract(declaredTestedClass.getModifiers()) ? this.generateSubclass(declaredType, declaredTestedClass) : declaredTestedClass;
        this.testedClass = new TestedClass(declaredType, declaredTestedClass);
    }

    @Nonnull
    private Class<?> generateSubclass(final @Nonnull Type testedType, final @Nonnull Class<?> abstractClass) {
        Class generatedSubclass = new ImplementationClass<Object>(abstractClass){

            @Override
            @Nonnull
            protected ClassVisitor createMethodBodyGenerator(@Nonnull ClassReader typeReader) {
                return new SubclassGenerationModifier(abstractClass, testedType, typeReader, this.generatedClassName, true);
            }
        }.generateClass();
        TestRun.mockFixture().registerMockedClass(generatedSubclass);
        return generatedSubclass;
    }

    TestedObjectCreation(@Nonnull InjectionState injectionState, @Nullable FullInjection fullInjection, @Nonnull Class<?> implementationClass) {
        this.injectionState = injectionState;
        this.fullInjection = fullInjection;
        this.actualTestedClass = implementationClass;
        this.testedClass = new TestedClass(implementationClass, implementationClass);
    }

    @Nonnull
    Object create() {
        ConstructorSearch constructorSearch = new ConstructorSearch(this.injectionState, this.actualTestedClass, this.fullInjection != null);
        Constructor<?> constructor = constructorSearch.findConstructorToUse();
        if (constructor == null) {
            String description = constructorSearch.getDescription();
            throw new IllegalArgumentException("No constructor in tested class that can be satisfied by available injectables" + description);
        }
        ConstructorInjection constructorInjection = new ConstructorInjection(this.testedClass, this.injectionState, this.fullInjection, constructor);
        return constructorInjection.instantiate(constructorSearch.parameterProviders);
    }
}

