/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.mockups;

import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.MockUp;
import mockit.external.asm.ClassReader;
import mockit.internal.BaseClassModifier;
import mockit.internal.ClassFile;
import mockit.internal.mockups.MockMethodCollector;
import mockit.internal.mockups.MockMethods;
import mockit.internal.mockups.MockupsModifier;
import mockit.internal.startup.Startup;
import mockit.internal.state.CachedClassfiles;
import mockit.internal.state.MockClasses;
import mockit.internal.state.TestRun;

public final class MockClassSetup {
    @Nonnull
    final Class<?> realClass;
    @Nullable
    private ClassReader rcReader;
    @Nonnull
    private final MockMethods mockMethods;
    @Nonnull
    final MockUp<?> mockUp;
    private final boolean forStartupMock;

    public MockClassSetup(@Nonnull Class<?> realClass, @Nonnull Class<?> classToMock, @Nullable Type mockedType, @Nonnull MockUp<?> mockUp) {
        this(realClass, classToMock, mockedType, mockUp, null);
    }

    public MockClassSetup(@Nonnull Class<?> realClass, @Nullable Type mockedType, @Nonnull MockUp<?> mockUp, @Nullable byte[] realClassCode) {
        this(realClass, realClass, mockedType, mockUp, realClassCode);
    }

    private MockClassSetup(@Nonnull Class<?> realClass, @Nonnull Class<?> classToMock, @Nullable Type mockedType, @Nonnull MockUp<?> mockUp, @Nullable byte[] realClassCode) {
        this.realClass = classToMock;
        this.mockMethods = new MockMethods(realClass, mockedType);
        this.mockUp = mockUp;
        this.forStartupMock = Startup.initializing;
        this.rcReader = realClassCode == null ? null : new ClassReader(realClassCode);
        Class<?> mockUpClass = mockUp.getClass();
        new MockMethodCollector(this.mockMethods).collectMockMethods(mockUpClass);
        this.mockMethods.registerMockStates(mockUp, this.forStartupMock);
        MockClasses mockClasses = TestRun.getMockClasses();
        if (this.forStartupMock) {
            mockClasses.addMock(this.mockMethods.getMockClassInternalName(), mockUp);
        } else {
            mockClasses.addMock(mockUp);
        }
    }

    public void redefineMethodsInGeneratedClass() {
        byte[] modifiedClassFile = this.modifyRealClass(this.realClass);
        if (modifiedClassFile != null) {
            this.applyClassModifications(this.realClass, modifiedClassFile);
        }
    }

    @Nonnull
    public Set<Class<?>> redefineMethods() {
        return this.redefineMethodsInClassHierarchy();
    }

    @Nonnull
    private Set<Class<?>> redefineMethodsInClassHierarchy() {
        HashSet redefinedClasses = new HashSet();
        Class<?> classToModify = this.realClass;
        while (classToModify != null && this.mockMethods.hasUnusedMocks()) {
            Class<?> superClass;
            byte[] modifiedClassFile = this.modifyRealClass(classToModify);
            if (modifiedClassFile != null) {
                this.applyClassModifications(classToModify, modifiedClassFile);
                redefinedClasses.add(classToModify);
            }
            classToModify = (superClass = classToModify.getSuperclass()) == Object.class || superClass == Proxy.class ? null : superClass;
            this.rcReader = null;
        }
        return redefinedClasses;
    }

    @Nullable
    private byte[] modifyRealClass(@Nonnull Class<?> classToModify) {
        if (this.rcReader == null) {
            this.rcReader = MockClassSetup.createClassReaderForRealClass(classToModify);
        }
        MockupsModifier modifier = new MockupsModifier(this.rcReader, classToModify, this.mockUp, this.mockMethods);
        this.rcReader.accept(modifier, 4);
        return modifier.wasModified() ? modifier.toByteArray() : null;
    }

    @Nonnull
    BaseClassModifier createClassModifier(@Nonnull ClassReader cr) {
        return new MockupsModifier(cr, this.realClass, this.mockUp, this.mockMethods);
    }

    @Nonnull
    private static ClassReader createClassReaderForRealClass(@Nonnull Class<?> classToModify) {
        return ClassFile.createReaderFromLastRedefinitionIfAny(classToModify);
    }

    void applyClassModifications(@Nonnull Class<?> classToModify, @Nonnull byte[] modifiedClassFile) {
        Startup.redefineMethods(classToModify, modifiedClassFile);
        if (this.forStartupMock) {
            CachedClassfiles.addClassfile(classToModify, modifiedClassFile);
        } else {
            String mockClassDesc = this.mockMethods.getMockClassInternalName();
            TestRun.mockFixture().addRedefinedClass(mockClassDesc, classToModify, modifiedClassFile);
        }
    }
}

