/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.mockups;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.BaseInvocation;
import mockit.internal.mockups.MockState;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

public final class MockInvocation
extends BaseInvocation {
    @Nonnull
    private final MockState mockState;
    @Nonnull
    private final String mockedClassDesc;
    @Nonnull
    private final String mockedMethodName;
    @Nonnull
    private final String mockedMethodDesc;
    boolean proceeding;

    @Nonnull
    public static MockInvocation create(@Nullable Object invokedInstance, @Nullable Object[] invokedArguments, @Nonnull String mockClassDesc, int mockStateIndex, @Nonnull String mockedClassDesc, @Nonnull String mockedMethodName, @Nonnull String mockedMethodDesc) {
        Object mockUp = TestRun.getMock(mockClassDesc, invokedInstance);
        assert (mockUp != null);
        MockState mockState = TestRun.getMockStates().getMockState(mockUp, mockStateIndex);
        Object[] args = invokedArguments == null ? Utilities.NO_ARGS : invokedArguments;
        return new MockInvocation(invokedInstance, args, mockState, mockedClassDesc, mockedMethodName, mockedMethodDesc);
    }

    MockInvocation(@Nullable Object invokedInstance, @Nonnull Object[] invokedArguments, @Nonnull MockState mockState, @Nonnull String mockedClassDesc, @Nonnull String mockedMethodName, @Nonnull String mockedMethodDesc) {
        super(invokedInstance, invokedArguments, mockState.getTimesInvoked());
        this.mockState = mockState;
        this.mockedClassDesc = mockedClassDesc;
        this.mockedMethodName = mockedMethodName;
        this.mockedMethodDesc = mockedMethodDesc;
    }

    @Override
    @Nonnull
    protected Member findRealMember() {
        Object invokedInstance = this.getInvokedInstance();
        if (invokedInstance != null) {
            Class<?> mockedClass = invokedInstance.getClass();
            return this.mockState.getRealMethodOrConstructor(mockedClass, this.mockedMethodName, this.mockedMethodDesc);
        }
        return this.mockState.getRealMethodOrConstructor(this.mockedClassDesc, this.mockedMethodName, this.mockedMethodDesc);
    }

    public boolean shouldProceedIntoConstructor() {
        if (this.proceeding && this.getInvokedMember() instanceof Constructor) {
            this.mockState.clearProceedIndicator();
            return true;
        }
        return false;
    }

    @Override
    public void prepareToProceed() {
        this.mockState.prepareToProceed(this);
        this.proceeding = true;
    }

    public void prepareToProceedFromNonRecursiveMock() {
        this.mockState.prepareToProceedFromNonRecursiveMock(this);
        this.proceeding = true;
    }

    @Override
    public void cleanUpAfterProceed() {
        this.mockState.clearProceedIndicator();
    }
}

