/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.mockups;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.MockUp;
import mockit.external.asm.AnnotationVisitor;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassVisitor;
import mockit.external.asm.Label;
import mockit.external.asm.MethodVisitor;
import mockit.internal.ClassFile;
import mockit.internal.mockups.MockMethods;
import mockit.internal.mockups.MockState;
import mockit.internal.state.ParameterNames;
import mockit.internal.util.ClassLoad;

final class MockMethodCollector
extends ClassVisitor {
    private static final int INVALID_METHOD_ACCESSES = 5440;
    @Nonnull
    private final MockMethods mockMethods;
    private boolean collectingFromSuperClass;
    @Nullable
    private String enclosingClassDescriptor;

    MockMethodCollector(@Nonnull MockMethods mockMethods) {
        this.mockMethods = mockMethods;
    }

    void collectMockMethods(@Nonnull Class<?> mockClass) {
        ClassLoad.registerLoadedClass(mockClass);
        Class<?> classToCollectMocksFrom = mockClass;
        do {
            ClassReader mcReader = ClassFile.readFromFile(classToCollectMocksFrom);
            mcReader.accept(this, 5);
            classToCollectMocksFrom = classToCollectMocksFrom.getSuperclass();
            this.collectingFromSuperClass = true;
        } while (classToCollectMocksFrom != Object.class && classToCollectMocksFrom != MockUp.class);
    }

    @Override
    public void visit(int version, int access, @Nonnull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        if (!this.collectingFromSuperClass) {
            this.mockMethods.setMockClassInternalName(name);
            int p = name.lastIndexOf(36);
            if (p > 0) {
                this.enclosingClassDescriptor = "(L" + name.substring(0, p) + ";)V";
            }
        }
    }

    @Override
    @Nullable
    public MethodVisitor visitMethod(int access, @Nonnull String methodName, @Nonnull String methodDesc, String methodSignature, String[] exceptions) {
        if ((access & 0x1540) != 0) {
            return null;
        }
        if ("<init>".equals(methodName)) {
            if (!this.collectingFromSuperClass && methodDesc.equals(this.enclosingClassDescriptor)) {
                this.enclosingClassDescriptor = null;
            }
            return null;
        }
        return new MockMethodVisitor(access, methodName, methodDesc);
    }

    private final class MockMethodVisitor
    extends MethodVisitor {
        private final int access;
        @Nonnull
        private final String methodName;
        @Nonnull
        private final String methodDesc;

        MockMethodVisitor(@Nonnull int access, @Nonnull String methodName, String methodDesc) {
            this.access = access;
            this.methodName = methodName;
            this.methodDesc = methodDesc;
        }

        @Override
        @Nullable
        public AnnotationVisitor visitAnnotation(@Nullable String desc, boolean visible) {
            MockMethods.MockMethod mockMethod;
            if ("Lmockit/Mock;".equals(desc) && (mockMethod = MockMethodCollector.this.mockMethods.addMethod(MockMethodCollector.this.collectingFromSuperClass, this.access, this.methodName, this.methodDesc)) != null && mockMethod.requiresMockState()) {
                MockState mockState = new MockState(mockMethod);
                MockMethodCollector.this.mockMethods.addMockState(mockState);
            }
            return null;
        }

        @Override
        public void visitLocalVariable(@Nonnull String name, @Nonnull String desc, String signature, Label start, Label end, @Nonnegative int index) {
            String classDesc = MockMethodCollector.this.mockMethods.getMockClassInternalName();
            ParameterNames.registerName(classDesc, this.access, this.methodName, this.methodDesc, desc, name, index);
        }
    }
}

