/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.Type;
import mockit.internal.state.MockedTypeCascade;
import mockit.internal.util.Utilities;

public final class CascadingTypes {
    @Nonnull
    private final Map<String, MockedTypeCascade> cascadingTypes = new ConcurrentHashMap<String, MockedTypeCascade>(4);

    CascadingTypes() {
    }

    public void add(boolean fromMockField, @Nonnull java.lang.reflect.Type mockedType) {
        Class<?> mockedClass = Utilities.getClassType(mockedType);
        String mockedTypeDesc = Type.getInternalName(mockedClass);
        this.add(mockedTypeDesc, fromMockField, mockedType);
    }

    void add(@Nonnull String mockedTypeDesc, boolean fromMockField, @Nonnull java.lang.reflect.Type mockedType) {
        if (!this.cascadingTypes.containsKey(mockedTypeDesc)) {
            this.cascadingTypes.put(mockedTypeDesc, new MockedTypeCascade(fromMockField, mockedType));
        }
    }

    @Nullable
    public MockedTypeCascade getCascade(@Nonnull String mockedTypeDesc, @Nullable Object mockInstance) {
        if (this.cascadingTypes.isEmpty()) {
            return null;
        }
        MockedTypeCascade cascade = this.getCascade(mockedTypeDesc);
        if (cascade != null || mockInstance == null) {
            return cascade;
        }
        return this.getCascade(mockedTypeDesc, mockInstance.getClass());
    }

    @Nullable
    private MockedTypeCascade getCascade(@Nonnull String mockedTypeDesc) {
        MockedTypeCascade cascade = this.cascadingTypes.get(mockedTypeDesc);
        if (cascade != null) {
            return cascade;
        }
        for (Map.Entry<String, MockedTypeCascade> cascadeEntry : this.cascadingTypes.entrySet()) {
            String cascadingTypeDesc = cascadeEntry.getKey();
            int p = cascadingTypeDesc.indexOf(60);
            if (p <= 0 || !cascadingTypeDesc.regionMatches(0, mockedTypeDesc, 0, p - 1)) continue;
            return cascadeEntry.getValue();
        }
        return null;
    }

    @Nullable
    private MockedTypeCascade getCascade(@Nonnull String invokedTypeDesc, @Nonnull Class<?> mockedClass) {
        Class<?> typeToLookFor = mockedClass;
        do {
            String typeDesc;
            if (invokedTypeDesc.equals(typeDesc = Type.getInternalName(typeToLookFor))) {
                return null;
            }
            MockedTypeCascade cascade = this.getCascade(typeDesc);
            if (cascade != null) {
                cascade.mockedClass = mockedClass;
                return cascade;
            }
            cascade = this.getCascadeForInterface(invokedTypeDesc, typeToLookFor);
            if (cascade == null) continue;
            return cascade;
        } while ((typeToLookFor = typeToLookFor.getSuperclass()) != Object.class);
        return null;
    }

    @Nullable
    private MockedTypeCascade getCascadeForInterface(@Nonnull String invokedTypeDesc, @Nonnull Class<?> mockedClass) {
        for (Class<?> mockedInterface : mockedClass.getInterfaces()) {
            MockedTypeCascade cascade = this.getCascade(invokedTypeDesc, mockedInterface);
            if (cascade == null) continue;
            return cascade;
        }
        return null;
    }

    void clearNonSharedCascadingTypes() {
        if (!this.cascadingTypes.isEmpty()) {
            Iterator<MockedTypeCascade> itr = this.cascadingTypes.values().iterator();
            while (itr.hasNext()) {
                MockedTypeCascade cascade = itr.next();
                if (cascade.fromMockField) {
                    cascade.discardCascadedMocks();
                    continue;
                }
                itr.remove();
            }
        }
    }

    public void clear() {
        this.cascadingTypes.clear();
    }
}

