/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.state.TestRun;

public final class ClassLoad {
    public static final String OBJECT = "java/lang/Object";
    private static final ClassLoader THIS_CL = ClassLoad.class.getClassLoader();
    private static final Map<String, Class<?>> LOADED_CLASSES = new ConcurrentHashMap();
    private static final Map<String, String> SUPER_CLASSES = new ConcurrentHashMap<String, String>();

    private ClassLoad() {
    }

    public static void registerLoadedClass(@Nonnull Class<?> aClass) {
        LOADED_CLASSES.put(aClass.getName(), aClass);
    }

    @Nonnull
    public static <T> Class<T> loadByInternalName(@Nonnull String internalClassName) {
        return ClassLoad.loadClass(internalClassName.replace('/', '.'));
    }

    @Nonnull
    public static <T> Class<T> loadClass(@Nonnull String className) {
        Class<?> loadedClass = LOADED_CLASSES.get(className);
        if (loadedClass == null) {
            try {
                loadedClass = ClassLoad.loadClassFromAClassLoader(className);
            }
            catch (LinkageError e) {
                e.printStackTrace();
                throw e;
            }
        }
        return loadedClass;
    }

    @Nonnull
    private static Class<?> loadClassFromAClassLoader(@Nonnull String className) {
        Class<?> loadedClass = ClassLoad.loadClass(null, className);
        if (loadedClass == null) {
            if (className.startsWith("mockit.")) {
                loadedClass = ClassLoad.loadClass(THIS_CL, className);
            }
            if (loadedClass == null) {
                ClassLoader contextCL;
                Class<?> testClass = TestRun.getCurrentTestClass();
                Class<?> clazz = loadedClass = testClass == null ? null : ClassLoad.loadClass(testClass.getClassLoader(), className);
                if (loadedClass == null && (loadedClass = ClassLoad.loadClass(contextCL = Thread.currentThread().getContextClassLoader(), className)) == null) {
                    throw new IllegalArgumentException("No class with name \"" + className + "\" found");
                }
            }
        }
        return loadedClass;
    }

    @Nonnull
    public static <T> Class<T> loadClassAtStartup(@Nonnull String className) {
        Class<?> loadedClass;
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        try {
            loadedClass = ClassLoad.loadClass(contextCL, className);
            if (loadedClass == null && (loadedClass = ClassLoad.loadClass(THIS_CL, className)) == null) {
                throw new IllegalArgumentException("No class with name \"" + className + "\" found");
            }
        }
        catch (LinkageError e) {
            e.printStackTrace();
            throw e;
        }
        return loadedClass;
    }

    @Nullable
    public static Class<?> loadClass(@Nullable ClassLoader loader, @Nonnull String className) {
        try {
            return Class.forName(className, false, loader);
        }
        catch (ClassNotFoundException ignore) {
            return null;
        }
    }

    @Nonnull
    public static <T> Class<T> loadFromLoader(@Nullable ClassLoader loader, @Nonnull String className) {
        try {
            return Class.forName(className, false, loader);
        }
        catch (ClassNotFoundException ignore) {
            throw new IllegalArgumentException("No class with name \"" + className + "\" found");
        }
    }

    @Nullable
    public static <T> Class<? extends T> searchTypeInClasspath(@Nonnull String typeName) {
        return ClassLoad.searchTypeInClasspath(typeName, false);
    }

    @Nullable
    public static <T> Class<? extends T> searchTypeInClasspath(@Nonnull String typeName, boolean initializeType) {
        try {
            return Class.forName(typeName, initializeType, THIS_CL);
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    public static void addSuperClass(@Nonnull String classInternalName, @Nonnull String superClassInternalName) {
        SUPER_CLASSES.put(classInternalName.intern(), superClassInternalName.intern());
    }

    @Nonnull
    public static String getSuperClass(@Nonnull String classInternalName) {
        Class theClass;
        Class superClass;
        String classDesc = classInternalName.intern();
        String superName = SUPER_CLASSES.get(classDesc);
        if (superName == null && (superClass = (theClass = ClassLoad.loadByInternalName(classDesc)).getSuperclass()) != null) {
            superName = superClass.getName().replace('.', '/').intern();
            SUPER_CLASSES.put(classDesc, superName);
        }
        return superName == null ? OBJECT : superName;
    }

    @Nullable
    public static String whichIsSuperClass(@Nonnull String internalClassName1, @Nonnull String internalClassName2) {
        String class1 = ClassLoad.actualSuperClass(internalClassName1, internalClassName2);
        if (class1 != null) {
            return class1;
        }
        String class2 = ClassLoad.actualSuperClass(internalClassName2, internalClassName1);
        return class2;
    }

    @Nullable
    private static String actualSuperClass(@Nonnull String candidateSuperClass, @Nonnull String candidateSubclass) {
        String subclass = candidateSubclass;
        String superClass;
        while (!(superClass = ClassLoad.getSuperClass(subclass)).equals(OBJECT)) {
            if (superClass.equals(candidateSuperClass)) {
                return candidateSuperClass;
            }
            subclass = superClass;
        }
        return null;
    }

    public static boolean isGeneratedSubclass(@Nonnull String className) {
        int p = className.indexOf(36) + 1;
        if (p < 2 || p == className.length() || className.charAt(p) != '$') {
            return false;
        }
        return className.contains("_$$_javassist_") || className.contains("_$$_jvst") || className.contains("CGLIB$$");
    }

    public static boolean isClassLoaderWithNoDirectAccess(@Nullable ClassLoader classLoader) {
        return classLoader == null || classLoader != THIS_CL && classLoader.getParent() != THIS_CL;
    }

    public static ClassLoader getClassLoaderWithAccess(@Nonnull Class<?> classToBeAccessed) {
        ClassLoader cl = classToBeAccessed.getClassLoader();
        return ClassLoad.isClassLoaderWithNoDirectAccess(cl) ? THIS_CL : cl;
    }
}

