/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.io.IOException;
import javax.annotation.Nonnull;

public final class StackTrace {
    @Nonnull
    private final Throwable throwable;
    @Nonnull
    private StackTraceElement[] elements;

    public StackTrace(@Nonnull Throwable throwable) {
        this.throwable = throwable;
        this.elements = throwable.getStackTrace();
    }

    public int getDepth() {
        return this.elements.length;
    }

    @Nonnull
    public StackTraceElement getElement(int index) {
        return this.elements[index];
    }

    public static void filterStackTrace(@Nonnull Throwable t) {
        new StackTrace(t).filter();
    }

    public void filter() {
        StackTraceElement[] filteredST = new StackTraceElement[this.elements.length];
        int i = 0;
        for (StackTraceElement ste : this.elements) {
            if (ste.getFileName() == null) continue;
            String where = ste.getClassName();
            if (StackTrace.isJDKInternalMethod(ste) || StackTrace.isTestFrameworkMethod(where) || StackTrace.isJMockitMethod(where)) continue;
            filteredST[i] = ste;
            ++i;
        }
        StackTraceElement[] newStackTrace = new StackTraceElement[i];
        System.arraycopy(filteredST, 0, newStackTrace, 0, i);
        this.throwable.setStackTrace(newStackTrace);
        this.elements = newStackTrace;
        Throwable cause = this.throwable.getCause();
        if (cause != null) {
            new StackTrace(cause).filter();
        }
    }

    private static boolean isJDKInternalMethod(@Nonnull StackTraceElement ste) {
        String className = ste.getClassName();
        return className.startsWith("sun.") && !ste.isNativeMethod() || className.startsWith("jdk.") || className.contains(".reflect.") || className.contains(".surefire.") || className.contains(".intellij.") || className.contains(".jdt.");
    }

    private static boolean isTestFrameworkMethod(@Nonnull String where) {
        return where.startsWith("org.junit.") || where.startsWith("org.testng.");
    }

    private static boolean isJMockitMethod(@Nonnull String where) {
        if (!where.startsWith("mockit.")) {
            return false;
        }
        int p = where.indexOf(36);
        if (p < 0) {
            int q = where.lastIndexOf("Test");
            return q < 0 || q + 4 < where.length();
        }
        int q = where.lastIndexOf("Test", p - 4);
        if (q < 0) {
            return true;
        }
        return (q += 4) < where.length() && where.charAt(q) != '$';
    }

    public void print(@Nonnull Appendable output) {
        String previousFileName = null;
        int previousLineNumber = 0;
        String sep = "";
        int d = this.getDepth();
        for (int i = 0; i < d; ++i) {
            StackTraceElement ste = this.elements[i];
            if (ste.getLineNumber() == previousLineNumber && ste.getFileName().equals(previousFileName)) continue;
            try {
                output.append(sep).append("\tat ").append(ste.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            sep = "\n";
            previousFileName = ste.getFileName();
            previousLineNumber = ste.getLineNumber();
        }
    }
}

