/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import javax.annotation.Nonnull;
import mockit.external.asm.Type;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.ParameterReflection;

public final class TypeDescriptor {
    private static final Class<?>[] PRIMITIVE_TYPES = new Class[]{Void.TYPE, Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Long.TYPE, Double.TYPE};

    private TypeDescriptor() {
    }

    @Nonnull
    public static Class<?>[] getParameterTypes(@Nonnull String methodDesc) {
        Type[] paramTypes = Type.getArgumentTypes(methodDesc);
        if (paramTypes.length == 0) {
            return ParameterReflection.NO_PARAMETERS;
        }
        Class[] paramClasses = new Class[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramClasses[i] = TypeDescriptor.getClassForType(paramTypes[i]);
        }
        return paramClasses;
    }

    @Nonnull
    public static Class<?> getReturnType(@Nonnull String methodSignature) {
        String methodDesc = TypeDescriptor.methodDescriptionWithoutTypeArguments(methodSignature);
        Type returnType = Type.getReturnType(methodDesc);
        return TypeDescriptor.getClassForType(returnType);
    }

    @Nonnull
    private static String methodDescriptionWithoutTypeArguments(@Nonnull String methodSignature) {
        int p;
        while ((p = methodSignature.indexOf(60)) >= 0) {
            String firstPart = methodSignature.substring(0, p);
            int q = methodSignature.indexOf(62, p) + 1;
            if (methodSignature.charAt(q) == '.') {
                methodSignature = firstPart + '$' + methodSignature.substring(q + 1);
                continue;
            }
            methodSignature = firstPart + methodSignature.substring(q);
        }
        return methodSignature;
    }

    @Nonnull
    public static Class<?> getClassForType(@Nonnull Type type) {
        String className;
        int sort = type.getSort();
        if (sort < PRIMITIVE_TYPES.length) {
            return PRIMITIVE_TYPES[sort];
        }
        if (sort == 9) {
            className = type.getDescriptor().replace('/', '.');
        } else {
            className = type.getClassName();
            assert (className != null);
        }
        return ClassLoad.loadClass(className);
    }
}

