#!/bin/bash
#**************************************************
# Copyright (c) 2011-2016 Cisco Systems, Inc.
# All rights reserved.
#**************************************************

XMS=64M
XMX=1024M

which java
java -version

#resolve directory absolute path
scriptname=$(echo $0 | sed s/.*\\///g)

if [ "$0" = "./$scriptname" ];then
abspath=$(echo `pwd`/$0 | sed "s/\/$scriptname//g" | sed "s/\/\.//g")
else
abspath=$(echo $0 | sed "s/\/$scriptname//g")
fi

#find java libraries and separate them with colon
jars=$(find $abspath/lib/ -name \*.jar | xargs echo | sed s/\ /:/g)

CP=$jars
colon=":"

CP=${CP}${colon}${abspath}/bin

echo $CP

#run the main class MigrationApplicationDriver
java -Xms$XMS -Xmx$XMX -classpath $CP com.cisco.acs.positron.migration.auto.MigrationExecutor $1 $2 $3 $4 $5 $6



