/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.util.regex.Pattern;
import subzero.lib.exceptions.IORuntimeException;
import subzero.lib.exceptions.IOTimeoutException;
import subzero.lib.io.CommandRegexHandler;
import subzero.lib.io.IOConnection;
import subzero.lib.io.RegexConnection;

public class CommandConnection
extends RegexConnection {
    private final String m_connectionName;
    private Pattern m_promptPattern;

    public CommandConnection(IOConnection ioc) {
        super(ioc);
        this.m_promptPattern = null;
        this.m_connectionName = "CommandConnection:" + ioc.getConnectionName();
    }

    public CommandConnection(IOConnection ioc, String promptRegex) {
        super(ioc);
        this.m_promptPattern = Pattern.compile(promptRegex);
        this.m_connectionName = "CommandConnection:" + ioc.getConnectionName();
    }

    public CommandConnection(IOConnection ioc, Pattern promptPattern) {
        super(ioc);
        this.m_promptPattern = promptPattern;
        this.m_connectionName = "CommandConnection:" + ioc.getConnectionName();
    }

    public void setPrompt(String promptRegex) {
        this.m_promptPattern = Pattern.compile(promptRegex);
    }

    public void setPrompt(Pattern pattern) {
        this.m_promptPattern = pattern;
    }

    public void sendCommand(String command) {
        if (command == null) {
            throw new NullPointerException("command parameter cannot be null");
        }
        this.sendText(command + (Object)((Object)this.m_returnChar));
    }

    public void sendCommand(String command, long timeoutms) throws IOTimeoutException {
        if (command == null) {
            throw new NullPointerException("command parameter cannot be null");
        }
        this.sendText(command + (Object)((Object)this.m_returnChar), timeoutms);
    }

    public String sendThenReadUntilPrompt(String command) {
        this.sendCommand(command);
        return this.readUntilPrompt();
    }

    public void sendCommandDoNotWaitForPrompt(String command, long timeout) {
        this.sendCommand(command);
        try {
            Thread.sleep(timeout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String sendThenReadUntilPrompt(String command, long timeoutms) throws IOTimeoutException {
        return this.sendThenReadUntilPrompt(command, timeoutms, false);
    }

    public String sendThenReadUntilPrompt(String command, long timeoutms, boolean absolute) throws IOTimeoutException {
        this.sendCommand(command, timeoutms);
        return this.readUntilPrompt(timeoutms, absolute);
    }

    public String sendThenReadUntilRegex(String command, String regex) {
        this.sendCommand(command);
        return this.readUntilRegex(regex);
    }

    public String sendThenReadUntilRegex(String command, Pattern pattern) {
        this.sendCommand(command);
        return this.readUntilRegex(pattern);
    }

    public String sendThenReadUntilRegex(String command, String regex, long timeoutms) throws IOTimeoutException {
        this.sendCommand(command, timeoutms);
        return this.readUntilRegex(regex, timeoutms);
    }

    public String sendThenReadUntilRegex(String command, Pattern pattern, long timeoutms) throws IOTimeoutException {
        return this.sendThenReadUntilRegex(command, pattern, timeoutms, false);
    }

    public String sendThenReadUntilRegex(String command, Pattern pattern, long timeoutms, boolean absolute) throws IOTimeoutException {
        this.sendCommand(command, timeoutms);
        return this.readUntilRegex(pattern, timeoutms, absolute);
    }

    public String readUntilPromptThenSend(String command) {
        String output = this.readUntilPrompt();
        this.sendCommand(command);
        return output;
    }

    public String readUntilPromptThenSend(String command, long timeoutms) throws IOTimeoutException {
        String output = this.readUntilPrompt(timeoutms);
        this.sendCommand(command, timeoutms);
        return output;
    }

    public String readUntilRegexThenSend(String regex, String command) {
        String output = this.readUntilRegex(regex);
        this.sendCommand(command);
        return output;
    }

    public String readUntilRegexThenSend(Pattern pattern, String command) {
        String output = this.readUntilRegex(pattern);
        this.sendCommand(command);
        return output;
    }

    public String readUntilRegexThenSend(String regex, String command, long timeoutms) throws IOTimeoutException {
        String output = this.readUntilRegex(regex, timeoutms);
        this.sendCommand(command, timeoutms);
        return output;
    }

    public String readUntilRegexThenSend(Pattern pattern, String command, long timeoutms) throws IOTimeoutException {
        return this.readUntilRegexThenSend(pattern, command, timeoutms, false);
    }

    public String readUntilRegexThenSend(Pattern pattern, String command, long timeoutms, boolean absolute) throws IOTimeoutException {
        String output = this.readUntilRegex(pattern, timeoutms, absolute);
        this.sendCommand(command, timeoutms);
        return output;
    }

    public String readUntilPrompt() {
        try {
            return this.readUntilPrompt(-1L);
        }
        catch (IOTimeoutException e) {
            throw new IORuntimeException(e);
        }
    }

    public String readUntilPrompt(long timeoutms) throws IOTimeoutException {
        return this.readUntilPrompt(timeoutms, false);
    }

    public String readUntilPrompt(long timeoutms, boolean absolute) throws IOTimeoutException {
        return this.readUntilRegex(this.m_promptPattern, timeoutms, absolute);
    }

    public String readUntilPrompt(String promptRegex, long timeoutms) throws IOTimeoutException {
        return this.readUntilRegex(promptRegex, timeoutms);
    }

    public String readUntilPrompt(Pattern pattern, long timeoutms) throws IOTimeoutException {
        return this.readUntilPrompt(pattern, timeoutms, false);
    }

    public String readUntilPrompt(Pattern pattern, long timeoutms, boolean absolute) throws IOTimeoutException {
        return this.readUntilRegex(pattern, timeoutms, absolute);
    }

    public void registerOptionalPrompt(String regex, String command, boolean matchMultipleTimes) {
        this.registerOptionalRegexHandler(new CommandRegexHandler(regex, command, matchMultipleTimes));
    }

    public void registerOptionalPrompt(Pattern pattern, String command, boolean matchMultipleTimes) {
        this.registerOptionalRegexHandler(new CommandRegexHandler(pattern, command, matchMultipleTimes));
    }

    public String getConnectionName() {
        return this.m_connectionName;
    }

    public Pattern getPromptPattern() {
        return this.m_promptPattern;
    }

    public static String getCommandResult(String result) {
        String[] tmp = result.split("\n");
        if (tmp.length < 2) {
            throw new RuntimeException("Unknown Command Response: [" + result + "]");
        }
        return tmp[1].trim();
    }

    public static String[] getCommandResult(String result, int length) {
        String[] tmp = result.split("\n");
        int endpoint = tmp.length - 1 - length;
        if (tmp.length < 2 || endpoint < 1 || endpoint > tmp.length) {
            throw new RuntimeException("Unknown Command Response: [" + result + "]");
        }
        String[] value = new String[endpoint];
        for (int i = 0; i < endpoint; ++i) {
            value[i] = tmp[i + 1].trim();
        }
        return value;
    }
}

