/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.IOException;
import java.io.InputStream;
import subzero.lib.io.WritableStringByteChannel;

public class LogMonitorInputStream
extends InputStream {
    private WritableStringByteChannel m_channel;
    private int m_pos;
    private boolean m_streamClosed = false;

    public LogMonitorInputStream(WritableStringByteChannel channel) {
        this.m_channel = channel;
        this.m_pos = 0;
    }

    public synchronized void close() throws IOException {
        this.m_streamClosed = true;
        this.m_channel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read() throws IOException {
        if (this.m_streamClosed) {
            throw new IOException("Cannot read from a stream that has been closed");
        }
        while (true) {
            WritableStringByteChannel writableStringByteChannel = this.m_channel;
            synchronized (writableStringByteChannel) {
                if (this.m_channel.isClosed() && this.available() == 0) {
                    return -1;
                }
                if (this.m_pos < this.m_channel.length()) {
                    int data = this.m_channel.charAt(this.m_pos) & 0xFF;
                    ++this.m_pos;
                    return data;
                }
                try {
                    this.m_channel.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.m_streamClosed) {
            throw new IOException("Cannot read from a stream that has been closed");
        }
        while (true) {
            WritableStringByteChannel writableStringByteChannel = this.m_channel;
            synchronized (writableStringByteChannel) {
                if (this.m_channel.isClosed() && this.available() == 0) {
                    return -1;
                }
                if (this.available() != 0) break;
                try {
                    this.m_channel.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        {
            int numToRead = Math.min(this.available(), len);
            int i = 0;
            while (i < numToRead) {
                b[off] = (byte)this.m_channel.charAt(this.m_pos);
                ++this.m_pos;
                ++off;
                ++i;
            }
            return numToRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int available() throws IOException {
        if (this.m_streamClosed) {
            throw new IOException("No bytes available from a stream that has been closed");
        }
        WritableStringByteChannel writableStringByteChannel = this.m_channel;
        synchronized (writableStringByteChannel) {
            return this.m_channel.length() - this.m_pos;
        }
    }
}

