/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.util;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;
import subzero.lib.exceptions.ArgumentsNotParsedException;
import subzero.lib.util.ExtendedGnuParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgHandler {
    protected static final Logger LOGGER = Logger.getLogger(ArgHandler.class);
    private Options options;
    private CommandLine cmdLine;
    private String appName;
    private int messageWidth = 120;

    public ArgHandler(String appName) {
        this.appName = appName;
        this.options = new Options();
    }

    public void addOption(String shortRep, boolean isRequired, String longRep, String description) {
        Option opt = new Option(shortRep, description);
        opt.setRequired(isRequired);
        opt.setArgName(longRep);
        opt.setLongOpt(longRep);
        this.options.addOption(opt);
    }

    public void addOption(String shortRep, boolean isRequired, String longRep, String argName, String description) {
        Option opt = new Option(shortRep, description);
        opt.setArgs(1);
        opt.setArgName(argName);
        opt.setRequired(isRequired);
        opt.setLongOpt(longRep);
        opt.setType(String.class);
        this.options.addOption(opt);
    }

    public void addOption(String shortRep, boolean isRequired, String longRep, String argName, Class<?> argType, String description) {
        Option opt = new Option(shortRep, description);
        opt.setArgs(1);
        opt.setArgName(argName);
        opt.setRequired(isRequired);
        opt.setLongOpt(longRep);
        opt.setType(argType);
        this.options.addOption(opt);
    }

    public void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(this.messageWidth);
        formatter.printHelp(this.appName, this.options, true);
        System.exit(1);
    }

    public void parse(String[] args) {
        ExtendedGnuParser parser = new ExtendedGnuParser(true);
        try {
            this.cmdLine = parser.parse(this.options, args);
        }
        catch (ParseException e) {
            LOGGER.error((Object)e.getMessage());
            this.printUsage();
        }
    }

    public String getValue(String opt) throws ArgumentsNotParsedException {
        if (this.cmdLine == null) {
            throw new ArgumentsNotParsedException();
        }
        return this.cmdLine.getOptionValue(opt);
    }

    public boolean hasValue(String opt) throws ArgumentsNotParsedException {
        if (this.cmdLine == null) {
            throw new ArgumentsNotParsedException();
        }
        return this.cmdLine.hasOption(opt);
    }

    public void setMessageWidth(int messageWidth) {
        this.messageWidth = messageWidth;
    }

    public int getMessageWidth() {
        return this.messageWidth;
    }
}

