/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.util;

import java.io.IOException;
import org.apache.log4j.Logger;
import subzero.lib.exceptions.IOTimeoutException;
import subzero.lib.io.CommandConnection;
import subzero.lib.io.IOCommands;
import subzero.lib.io.LoggingIOConnection;
import subzero.lib.io.TelnetConnection;

public class DnsUtils {
    private static Logger s_logger = Logger.getLogger(DnsUtils.class);

    public boolean addDnsRecord(String dnsServerIp, String dnsServerAdmin, String dnsServerPw, String serverNameToAdd, String ServerIpToAdd, String ServerDomainName) throws IOTimeoutException, IOException {
        boolean success = false;
        s_logger.info((Object)("Adding DNS record: \nHostname: " + serverNameToAdd + "\nIP: " + ServerIpToAdd + "\nDomain: " + ServerDomainName + "\n"));
        TelnetConnection mdc = new TelnetConnection(dnsServerIp, dnsServerAdmin, dnsServerPw, IOCommands.CR);
        LoggingIOConnection log = new LoggingIOConnection(mdc, "DNSaddRecord");
        CommandConnection API = new CommandConnection(log);
        log.setOutputLoggingEnabled(false);
        API.setReturnCharacter(IOCommands.CR);
        API.setPrompt(">");
        API.readUntilPrompt(60000L);
        String ret = API.sendThenReadUntilPrompt("dnscmd localhost /RecordAdd " + ServerDomainName + " " + serverNameToAdd + " A " + ServerIpToAdd, 30000L);
        if (ret.contains("successfully")) {
            success = true;
        }
        return success;
    }

    public boolean deleteDnsRecord(String dnsServerIp, String dnsServerAdmin, String dnsServerPw, String serverNameToDelete, String ServerIpToDelete, String ServerDomainName) throws IOTimeoutException, IOException {
        boolean success = false;
        s_logger.info((Object)("Adding DNS record: \nHostname: " + serverNameToDelete + "\nIP: " + ServerIpToDelete + "\nDomain: " + ServerDomainName + "\n"));
        TelnetConnection mdc = new TelnetConnection(dnsServerIp, dnsServerAdmin, dnsServerPw, IOCommands.CR);
        LoggingIOConnection log = new LoggingIOConnection(mdc, "DNSaddRecord");
        CommandConnection API = new CommandConnection(log);
        log.setOutputLoggingEnabled(false);
        API.setReturnCharacter(IOCommands.CR);
        API.setPrompt(">");
        API.readUntilPrompt(60000L);
        String ret = API.sendThenReadUntilPrompt("dnscmd localhost /RecordAdd " + ServerDomainName + " " + serverNameToDelete + " A " + ServerIpToDelete + "/f", 30000L);
        if (ret.contains("successfully")) {
            success = true;
        }
        return success;
    }

    public boolean addDnsReverseRecord(String dnsServerIp, String dnsServerAdmin, String dnsServerPw, String serverNameToAdd, String IpSuffix, String ServerDomainName) throws IOTimeoutException, IOException {
        boolean success = false;
        s_logger.info((Object)("Adding Reverse DNS record: \nIP : " + IpSuffix + "\nDomain: " + ServerDomainName + "\n"));
        TelnetConnection mdc = new TelnetConnection(dnsServerIp, dnsServerAdmin, dnsServerPw, IOCommands.CR);
        LoggingIOConnection log = new LoggingIOConnection(mdc, "DNSaddRecord");
        CommandConnection API = new CommandConnection(log);
        log.setOutputLoggingEnabled(false);
        API.setReturnCharacter(IOCommands.CR);
        API.setPrompt(">");
        API.readUntilPrompt(60000L);
        String ret = API.sendThenReadUntilPrompt("dnscmd " + ServerDomainName + "/RecordAdd  10.0.10.in-addr.arpa " + IpSuffix + " PTR " + serverNameToAdd + "." + ServerDomainName, 30000L);
        if (ret.contains("successfully")) {
            success = true;
        }
        return success;
    }
}

