/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import subzero.lib.exceptions.SSHRuntimeException;
import subzero.lib.io.CopyTo;
import subzero.lib.io.IFileEntry;
import subzero.lib.io.SFTPFileEntry;
import subzero.lib.io.SSHConnection;

public class CopyToSCP
extends CopyTo {
    private final ChannelSftp m_sftp;

    public CopyToSCP(SSHConnection ssh, String to) {
        super(to);
        try {
            this.m_sftp = (ChannelSftp)ssh.openChannel("sftp");
            this.m_sftp.connect();
        }
        catch (JSchException e) {
            SSHRuntimeException re = new SSHRuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
    }

    public void setBytes(byte[] b, IFileEntry entry) throws IOException {
        OutputStream out = this.getOutputStream(entry, b.length);
        out.write(b);
        out.close();
    }

    public boolean supportsStreaming() {
        return true;
    }

    public OutputStream getOutputStream(IFileEntry child, long fileSize) throws IOException {
        try {
            return this.m_sftp.put(child.getSystemPath());
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
    }

    public IFileEntry getFileEntry() {
        return new SFTPFileEntry(this.m_sftp, this, this.getTo());
    }

    public boolean makeDirectory(IFileEntry child) throws IOException {
        if (child.isDirectory()) {
            return true;
        }
        try {
            this.m_sftp.mkdir(child.getPath());
            return this.m_sftp.stat(child.getPath()).isDir();
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
    }

    public boolean setLastModified(IFileEntry child, long lastModified) throws IOException {
        try {
            SftpATTRS attrs;
            String path = child.getPath();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if ((attrs = this.m_sftp.stat(path)).isDir()) {
                return false;
            }
            attrs.setACMODTIME((int)lastModified, (int)lastModified);
            this.m_sftp.setStat(path, attrs);
            return true;
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
    }

    private boolean deleteDirectory(IFileEntry file) throws IOException {
        try {
            List<IFileEntry> children = file.getChildren();
            for (IFileEntry child : children) {
                if (child.isDirectory()) {
                    this.deleteDirectory(child);
                    continue;
                }
                this.m_sftp.rm(child.getSystemPath());
            }
            this.m_sftp.rmdir(file.getSystemPath());
        }
        catch (SftpException e) {
            throw new IOException("Unable to delete:" + file.getSystemPath());
        }
        return !file.exists();
    }

    public boolean deleteFile(int flag) throws IOException {
        return this.deleteFile(this.getFileEntry(), flag);
    }

    public boolean deleteFile(IFileEntry file, int flag) throws IOException {
        boolean result = false;
        try {
            if (file.isFile()) {
                this.m_sftp.rm(file.getSystemPath());
                result = !file.exists();
            } else if (flag == 0) {
                this.m_sftp.rmdir(file.getSystemPath());
                result = !file.exists();
            } else {
                result = this.deleteDirectory(file);
            }
        }
        catch (SftpException e) {
            throw new IOException("Could not delete " + file.getSystemPath());
        }
        return result;
    }
}

