/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import subzero.lib.exceptions.SSHException;
import subzero.lib.exceptions.SSHRuntimeException;
import subzero.lib.io.AbstractIOConnection;

public class SSHConnection
extends AbstractIOConnection {
    private static Logger s_logger;
    public static final int DEFAULT_PORT = 22;
    public static int SSH_CON_TIMEOUT;
    private final String m_connectionName;
    private InputStream m_in;
    private OutputStream m_out;
    private final JSch m_sshConnection;
    private final Session m_session;
    private Channel m_channel;
    private final boolean m_isRootConnection;
    private boolean m_hasShell;
    private int m_keepalive = 5000;

    public static void setSSH_CON_TIMEOUT(int ssh_con_timeout) {
        SSH_CON_TIMEOUT = ssh_con_timeout;
    }

    public SSHConnection(String host, String username, String password) throws IOException {
        this(host, 22, username, password, SSH_CON_TIMEOUT);
    }

    public SSHConnection(String host, int port, String username, String password, int timeout) throws IOException {
        s_logger.debug((Object)(host + ":" + port + " (" + username + "/" + password + ")"));
        this.m_connectionName = "ssh[" + username + "@" + host + "]";
        this.m_sshConnection = new JSch();
        try {
            this.m_session = this.m_sshConnection.getSession(username, host, port);
            this.m_session.setServerAliveInterval(this.m_keepalive);
            this.m_session.setPassword(password);
            this.m_session.setUserInfo((UserInfo)new MyUserInfo(null, password));
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            config.put("kex", "diffie-hellman-group1-sha1,diffie-hellman-group-exchange-sha1,diffie-hellman-group14-sha1");
            this.m_session.setConfig(config);
            this.m_session.connect(timeout * 1000);
            this.m_isRootConnection = true;
        }
        catch (JSchException e) {
            e.printStackTrace();
            throw new SSHException(e.getMessage());
        }
    }

    public SSHConnection(String host, String username, String passphrase, String privateKeyFilePath) throws IOException {
        this(host, 22, username, passphrase, privateKeyFilePath);
    }

    public SSHConnection(String host, int port, String username, String passphrase, String privateKeyFilePath) throws IOException {
        s_logger.debug((Object)(host + ":" + port + " (" + username + "/" + passphrase + ")"));
        this.m_connectionName = "ssh[" + username + "@" + host + "]";
        this.m_sshConnection = new JSch();
        try {
            this.m_sshConnection.addIdentity(privateKeyFilePath);
            this.m_session = this.m_sshConnection.getSession(username, host, port);
            this.m_session.setServerAliveInterval(this.m_keepalive);
            MyUserInfo ui = new MyUserInfo(passphrase, null);
            this.m_session.setUserInfo((UserInfo)ui);
            this.m_session.connect();
            this.m_isRootConnection = true;
        }
        catch (JSchException e) {
            throw new SSHException(e.getMessage());
        }
    }

    private SSHConnection(SSHConnection conn) throws IOException {
        this.m_session = conn.m_session;
        this.m_connectionName = conn.m_connectionName;
        this.m_sshConnection = conn.m_sshConnection;
        this.m_isRootConnection = false;
    }

    public String getHost() {
        return this.m_session.getHost();
    }

    public int getPort() {
        return this.m_session.getPort();
    }

    public void setKeepAliveInterval(int msec) throws JSchException {
        this.m_keepalive = msec;
        if (this.m_session != null) {
            this.m_session.setServerAliveInterval(this.m_keepalive);
        }
    }

    public String getConnectionName() {
        return this.m_connectionName;
    }

    public InputStream getInputStream() {
        if (!this.m_hasShell) {
            this.spawnShell();
        }
        return this.m_in;
    }

    public OutputStream getOutputStream() {
        if (!this.m_hasShell) {
            this.spawnShell();
        }
        return this.m_out;
    }

    public void close() throws IOException {
        if (this.m_hasShell) {
            this.m_channel.disconnect();
            this.m_out.close();
            this.m_in.close();
        }
        if (this.m_isRootConnection) {
            try {
                this.m_session.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isClosed() {
        if (this.m_hasShell) {
            return this.m_channel.isClosed();
        }
        if (this.m_isRootConnection) {
            return !this.m_session.isConnected();
        }
        return true;
    }

    public SSHConnection newShell() throws IOException {
        return new SSHConnection(this);
    }

    private synchronized void spawnShell() {
        if (this.m_hasShell) {
            return;
        }
        try {
            this.m_channel = this.openChannel("shell");
            ((ChannelShell)this.m_channel).setPtyType("vt100", 400, 24, 3200, 480);
            this.m_channel.connect();
            this.m_in = this.m_channel.getInputStream();
            this.m_out = this.m_channel.getOutputStream();
            this.m_hasShell = true;
        }
        catch (Throwable t) {
            throw new SSHRuntimeException("Unable to open \"shell\" channel", t);
        }
    }

    Channel openChannel(String type) throws JSchException {
        return this.m_session.openChannel(type);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        s_logger = Logger.getLogger(SSHConnection.class);
        SSH_CON_TIMEOUT = 30;
    }

    private static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private final String m_passphrase;
        private final String m_password;

        public MyUserInfo(String passphrase, String password) {
            this.m_passphrase = passphrase;
            this.m_password = password;
        }

        public String getPassword() {
            return this.m_password;
        }

        public boolean promptYesNo(String str) {
            return false;
        }

        public String getPassphrase() {
            return this.m_passphrase;
        }

        public boolean promptPassphrase(String message) {
            return this.m_passphrase != null;
        }

        public boolean promptPassword(String arg0) {
            return this.m_password != null;
        }

        public void showMessage(String arg0) {
            Logger.getLogger((String)"PASSTHRU").debug((Object)arg0);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            if (prompt.length != 1 || echo[0] || this.m_password == null) {
                return null;
            }
            String[] response = new String[]{this.m_password};
            return response;
        }
    }
}

