/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import subzero.lib.io.AbstractIOConnection;
import subzero.lib.io.IOConnection;
import subzero.lib.io.TimeoutInputStream;
import subzero.lib.io.TimeoutOutputStream;

public class TimeoutIOConnection
extends AbstractIOConnection
implements IOConnection {
    private final IOConnection m_ioc;
    private final TimeoutInputStream m_in;
    private final TimeoutOutputStream m_out;
    private int m_readTimeOut = 0;
    private int m_writeTimeout = 0;

    public TimeoutIOConnection(IOConnection ioc, int readTimeout, int writeTimeout) {
        this.m_ioc = ioc;
        this.m_readTimeOut = readTimeout;
        this.m_writeTimeout = writeTimeout;
        this.m_in = new TimeoutInputStream(this.m_ioc.getInputStream(), this.m_readTimeOut);
        this.m_out = new TimeoutOutputStream(this.m_ioc.getOutputStream(), this.m_writeTimeout);
    }

    public String getConnectionName() {
        return this.m_ioc.getConnectionName();
    }

    public InputStream getInputStream() {
        return this.m_in;
    }

    public OutputStream getOutputStream() {
        return this.m_out;
    }

    public void close() throws IOException {
        this.m_ioc.close();
    }

    public boolean isClosed() {
        return this.m_ioc.isClosed();
    }
}

