/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.www.pi_service;

import com.cisco.nm.acs.mgmt.pi.service.PI;
import com.cisco.nm.acs.mgmt.pi.service.PiSoapBindingStub;
import com.cisco.www.pi_service.PIService;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class PIServiceLocator
extends Service
implements PIService {
    private String PI_address = "http://localhost:8080/PI/services/PI";
    private String PIWSDDServiceName = "PI";
    private HashSet ports = null;

    public PIServiceLocator() {
    }

    public PIServiceLocator(EngineConfiguration config) {
        super(config);
    }

    public PIServiceLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    public String getPIAddress() {
        return this.PI_address;
    }

    public String getPIWSDDServiceName() {
        return this.PIWSDDServiceName;
    }

    public void setPIWSDDServiceName(String name) {
        this.PIWSDDServiceName = name;
    }

    public PI getPI() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.PI_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getPI(endpoint);
    }

    public PI getPI(URL portAddress) throws ServiceException {
        try {
            PiSoapBindingStub _stub = new PiSoapBindingStub(portAddress, this);
            _stub.setPortName(this.getPIWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setPIEndpointAddress(String address) {
        this.PI_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (PI.class.isAssignableFrom(serviceEndpointInterface)) {
                PiSoapBindingStub _stub = new PiSoapBindingStub(new URL(this.PI_address), this);
                _stub.setPortName(this.getPIWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("PI".equals(inputPortName)) {
            return this.getPI();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("http://www.cisco.com/pi.service", "PIService");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("http://www.cisco.com/pi.service", "PI"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"PI".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setPIEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

