/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.log4j.Logger;
import subzero.lib.exceptions.NASIOException;
import subzero.lib.io.ICopyFrom;
import subzero.lib.io.ICopyTo;
import subzero.lib.io.IFileEntry;
import subzero.lib.io.IFileEntryFilter;

public abstract class CopyFrom
implements ICopyFrom {
    private static final Logger LOGGER = Logger.getLogger(CopyFrom.class);
    private String m_from;

    public CopyFrom(String from) {
        this.m_from = from;
    }

    public String getFrom() {
        return this.m_from;
    }

    public void setFrom(String from) {
        this.m_from = from;
    }

    public void waitForData() {
        this.waitForData(10000);
    }

    public void waitForData(int time) {
        if (this.length() > 0) {
            return;
        }
        long endtime = System.currentTimeMillis() + (long)time;
        while (this.length() == 0 && endtime > System.currentTimeMillis()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract byte[] getBytes() throws IOException;

    public abstract int length();

    public abstract boolean supportStreaming();

    public void copyTo(ICopyTo copyToDest) throws IOException {
        this.copyTo(copyToDest, 0);
    }

    public void copyTo(ICopyTo copyToDest, int flags) throws IOException {
        this.copyTo(copyToDest, null, flags);
    }

    public void copyTo(ICopyTo copyToDest, IFileEntryFilter filter, int flags) throws IOException {
        IFileEntry srcentry = this.getFileEntry();
        IFileEntry destentry = copyToDest.getFileEntry();
        if (!srcentry.exists()) {
            throw new IOException(this.m_from + " (No such file or directory)");
        }
        if (filter != null && !filter.accept(srcentry)) {
            return;
        }
        if (srcentry.isFile()) {
            this.copyFile(srcentry, destentry, copyToDest, flags);
        } else if (!destentry.exists() || destentry.isDirectory()) {
            if (destentry.exists()) {
                destentry = destentry.newChild(srcentry.getName() + "/");
            }
            this.copyDir(srcentry, destentry, copyToDest, filter, flags);
        } else {
            throw new NASIOException("Unable to copy directory, destination location represents an existing file");
        }
    }

    private void copyDir(IFileEntry srcentry, IFileEntry destentry, ICopyTo copyto, IFileEntryFilter filter, int flags) throws IOException {
        if (!destentry.exists()) {
            LOGGER.debug((Object)("MKDIR: " + destentry.getSystemPath()));
            if (!copyto.makeDirectory(destentry)) {
                throw new NASIOException("Unabled to create directory: " + destentry.getSystemPath());
            }
        }
        List<IFileEntry> children = srcentry.getChildren();
        for (IFileEntry entry : children) {
            IFileEntry childentry;
            if (filter != null && !filter.accept(entry)) continue;
            if (entry.isDirectory()) {
                childentry = destentry.newChild(entry.getName() + "/");
                if (!destentry.exists()) {
                    LOGGER.debug((Object)("MKDIR2: " + childentry.getSystemPath()));
                    copyto.makeDirectory(childentry);
                }
                this.copyDir(entry, childentry, copyto, filter, flags);
                continue;
            }
            childentry = destentry.newChild(entry.getName());
            this.copyFile(entry, childentry, copyto, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(IFileEntry srcentry, IFileEntry destentry, ICopyTo copyto, int flags) throws IOException {
        if ((flags & 1) == 1 && srcentry.getLength() == destentry.getLength()) {
            LOGGER.debug((Object)("SKIP: " + destentry.getSystemPath() + " (same)"));
            return;
        }
        LOGGER.debug((Object)("COPY: " + destentry.getSystemPath()));
        if (this.supportStreaming() && copyto.supportsStreaming()) {
            OutputStream out = null;
            InputStream in = this.getInputStream(srcentry);
            try {
                int len;
                if (destentry.isDirectory()) {
                    IFileEntry child = destentry.newChild(srcentry.getName());
                    out = copyto.getOutputStream(child);
                } else {
                    out = copyto.getOutputStream(destentry);
                }
                byte[] buffer = new byte[32768];
                while ((len = in.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        if (destentry.isDirectory()) {
            IFileEntry child = destentry.newChild(srcentry.getName());
            copyto.setBytes(this.getBytes(), child);
        } else {
            copyto.setBytes(this.getBytes());
        }
    }
}

