/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import subzero.lib.io.CopyFrom;
import subzero.lib.io.FileEntryImpl;
import subzero.lib.io.IFileEntry;

public class CopyFromHTTP
extends CopyFrom {
    public CopyFromHTTP(String url) {
        super(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = this.getInputStream();
        try {
            byte[] buffer = new byte[16384];
            int numread = 0;
            while (0 <= (numread = in.read(buffer))) {
                baos.write(buffer, 0, numread);
            }
        }
        finally {
            in.close();
            baos.close();
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length() {
        URL url = new URL(this.getFrom());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setUseCaches(false);
        conn.setRequestMethod("HEAD");
        conn.connect();
        try {
            if (conn.getResponseCode() != 200) {
                throw new FileNotFoundException(this.getFrom());
            }
            int n = conn.getHeaderFieldInt("Content-Length", 0);
            conn.disconnect();
            return n;
        }
        catch (Throwable throwable) {
            try {
                conn.disconnect();
                throw throwable;
            }
            catch (Throwable t) {
                return -1;
            }
        }
    }

    public boolean supportStreaming() {
        return true;
    }

    public InputStream getInputStream() throws IOException {
        return this.getInputStream(this.getFileEntry());
    }

    public IFileEntry getFileEntry() {
        return new FileEntryImpl(this, this.getFrom(), false, this.length());
    }

    public InputStream getInputStream(IFileEntry child) throws IOException {
        URL url = new URL(this.getFrom());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setUseCaches(false);
        conn.setRequestMethod("GET");
        conn.connect();
        return conn.getInputStream();
    }
}

