/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;

public class WritableStringByteChannel
implements WritableByteChannel,
CharSequence {
    private final StringBuffer m_sb = new StringBuffer();
    private final byte[] m_buffer = new byte[1024];
    private boolean m_isClosed = false;

    public synchronized int write(ByteBuffer src) throws IOException {
        if (this.m_isClosed) {
            throw new ClosedChannelException();
        }
        int numToRead = src.remaining();
        int totalRead = 0;
        while (numToRead > 0) {
            int nextChunk = Math.min(this.m_buffer.length, numToRead);
            src.get(this.m_buffer, 0, nextChunk);
            this.m_sb.append(new String(this.m_buffer, 0, nextChunk));
            numToRead -= nextChunk;
            totalRead += nextChunk;
        }
        this.notifyAll();
        return totalRead;
    }

    public int length() {
        return this.m_sb.length();
    }

    public char charAt(int index) {
        return this.m_sb.charAt(index);
    }

    public CharSequence subSequence(int start, int end) {
        InternalCharSequence cs = new InternalCharSequence(start, end - start);
        cs.toString();
        return cs;
    }

    public String toString() {
        return this.m_sb.toString();
    }

    public synchronized void close() throws IOException {
        this.m_isClosed = true;
    }

    public synchronized boolean isClosed() {
        return this.m_isClosed;
    }

    public synchronized boolean isOpen() {
        return !this.m_isClosed;
    }

    public class InternalCharSequence
    implements CharSequence {
        private final int m_offset;
        private final int m_length;

        public InternalCharSequence(int offset, int length) {
            this.m_offset = offset;
            this.m_length = length;
        }

        public int length() {
            return this.m_length;
        }

        public char charAt(int index) {
            return WritableStringByteChannel.this.m_sb.charAt(this.m_offset + index);
        }

        public CharSequence subSequence(int start, int end) {
            return WritableStringByteChannel.this.subSequence(this.m_offset + start, this.m_offset + end);
        }

        public String toString() {
            return WritableStringByteChannel.this.m_sb.substring(this.m_offset, this.m_offset + this.m_length);
        }
    }
}

