/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipFileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFiledataFromZip(ZipFile zip, String file) {
        ZipEntry entry = zip.getEntry(file);
        if (entry == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream in = zip.getInputStream(entry);
            try {
                int numread = 0;
                byte[] buffer = new byte[16384];
                while (0 <= (numread = in.read(buffer))) {
                    baos.write(buffer, 0, numread);
                }
            }
            finally {
                in.close();
            }
            return baos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void createZipFile(File root, OutputStream destination) throws IOException {
        ZipFileUtils.createZipFile(root, destination, null);
    }

    public static void createZipFile(File root, OutputStream destination, FileFilter filter) throws IOException {
        ZipOutputStream zip = new ZipOutputStream(destination);
        ZipFileUtils.addToZipFile(zip, "", root, filter);
        zip.close();
    }

    public static void addToZipFile(ZipOutputStream zip, String basepath, File root) throws IOException {
        ZipFileUtils.addToZipFile(zip, basepath, root, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToZipFile(ZipOutputStream zip, String basepath, File root, FileFilter filter) throws IOException {
        if (root.isDirectory()) {
            block9: {
                basepath = basepath + root.getName();
                basepath = basepath + "/";
                try {
                    zip.putNextEntry(new ZipEntry(basepath));
                    zip.closeEntry();
                }
                catch (ZipException ze) {
                    if (ze.getMessage() != null && ze.getMessage().contains("duplicate entry")) break block9;
                    throw ze;
                }
            }
            File[] children = filter == null ? root.listFiles() : root.listFiles(filter);
            for (int i = 0; i < children.length; ++i) {
                ZipFileUtils.addToZipFile(zip, basepath, children[i], filter);
            }
        } else {
            ZipEntry ze = new ZipEntry(basepath + root.getName());
            zip.putNextEntry(ze);
            FileInputStream in = new FileInputStream(root);
            CRC32 crc = new CRC32();
            crc.reset();
            try {
                int numread;
                byte[] buffer = new byte[65536];
                while (0 < (numread = ((InputStream)in).read(buffer))) {
                    zip.write(buffer, 0, numread);
                    crc.update(buffer, 0, numread);
                }
                ze.setCrc(crc.getValue());
            }
            finally {
                ((InputStream)in).close();
            }
            zip.closeEntry();
        }
    }

    public static void createJarFile(File root, OutputStream destination) throws IOException {
        JarOutputStream jar = new JarOutputStream(destination);
        ZipFileUtils.addToJarFile(jar, "", root);
        jar.close();
    }

    public static void addToJarFile(JarOutputStream jar, String basepath, File root) throws IOException {
        ZipFileUtils.addToJarFile(jar, basepath, root, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToJarFile(JarOutputStream jar, String basepath, File root, FileFilter filter) throws IOException {
        if (root.isDirectory()) {
            block9: {
                basepath = basepath + root.getName();
                basepath = basepath + "/";
                try {
                    jar.putNextEntry(new JarEntry(basepath));
                    jar.closeEntry();
                }
                catch (ZipException ze) {
                    if (ze.getMessage() != null && ze.getMessage().contains("duplicate entry")) break block9;
                    throw ze;
                }
            }
            File[] children = filter == null ? root.listFiles() : root.listFiles(filter);
            for (int i = 0; i < children.length; ++i) {
                ZipFileUtils.addToJarFile(jar, basepath, children[i], filter);
            }
        } else {
            JarEntry je = new JarEntry(basepath + root.getName());
            jar.putNextEntry(je);
            FileInputStream in = new FileInputStream(root);
            CRC32 crc = new CRC32();
            crc.reset();
            try {
                int numread;
                byte[] buffer = new byte[65536];
                while (0 < (numread = ((InputStream)in).read(buffer))) {
                    jar.write(buffer, 0, numread);
                    crc.update(buffer, 0, numread);
                }
                je.setCrc(crc.getValue());
            }
            finally {
                ((InputStream)in).close();
            }
            jar.closeEntry();
        }
    }

    public static void extractZipFile(InputStream inputStream, File destination) throws IOException {
        ZipFileUtils.extractZipFile(inputStream, destination, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractZipFile(InputStream inputStream, File destination, boolean continueOnWriteFail) throws IOException {
        ZipEntry entry;
        IOException exception = null;
        destination.mkdirs();
        ZipInputStream zip = new ZipInputStream(inputStream);
        byte[] buffer = new byte[65536];
        while ((entry = zip.getNextEntry()) != null) {
            File file = new File(destination, entry.getName());
            if (entry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            file.getParentFile().mkdirs();
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                int numRead = zip.read(buffer);
                while (numRead > 0) {
                    ((OutputStream)out).write(buffer, 0, numRead);
                    numRead = zip.read(buffer);
                }
            }
            catch (IOException ioe) {
                if (!continueOnWriteFail) {
                    throw ioe;
                }
                if (exception != null) continue;
                exception = ioe;
            }
            finally {
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception exception2) {}
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static byte[] extractFileFromZip(File sourceFile, String filename) throws IOException {
        Map files = ZipFileUtils.extractFilesFromZip(sourceFile, new String[]{filename});
        return (byte[])files.get(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map extractFilesFromZip(File sourceFile, String[] filename) throws IOException {
        HashMap<String, byte[]> files;
        block12: {
            files = new HashMap<String, byte[]>();
            ZipInputStream zis = new ZipInputStream(new FileInputStream(sourceFile));
            block4: while (true) {
                ZipEntry entry = zis.getNextEntry();
                if (null != entry) {
                    int i = 0;
                    while (true) {
                        if (i >= filename.length) continue block4;
                        if (entry.getName().equalsIgnoreCase(filename[i])) {
                            if (entry.getSize() != -1L) {
                                byte[] buffer = new byte[(int)entry.getSize()];
                                new DataInputStream(zis).readFully(buffer);
                                files.put(filename[i], buffer);
                            } else {
                                int numread;
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                byte[] buffer = new byte[16384];
                                while (0 <= (numread = zis.read(buffer))) {
                                    baos.write(buffer, 0, numread);
                                }
                                files.put(filename[i], baos.toByteArray());
                            }
                        }
                        if (files.size() == filename.length) {
                            HashMap<String, byte[]> hashMap = files;
                            return hashMap;
                        }
                        ++i;
                    }
                }
                break block12;
                break;
            }
            finally {
                zis.close();
            }
        }
        return files;
    }

    public static boolean isZipFileValid(File zip) {
        try {
            ZipInputStream in = new ZipInputStream(new FileInputStream(zip));
            while (in.getNextEntry() != null) {
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

