/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.utils;

import com.gentlyweb.utils.TimeDuration;
import com.gentlyweb.utils.Timing;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class Timings {
    public static final int TIME_ORDERED = 0;
    public static final int RANDOM = 1;
    public static final int KEY_ORDERED = 2;
    private Map ts = null;

    public Timings(int type) {
        if (type == 0) {
            this.ts = new LinkedHashMap();
            return;
        }
        if (type == 2) {
            this.ts = new TreeMap();
            return;
        }
        this.ts = new HashMap();
    }

    public Iterator iterator() {
        if (this.ts instanceof TreeMap) {
            TreeMap m = new TreeMap(this.ts);
            return m.keySet().iterator();
        }
        if (this.ts instanceof LinkedHashMap) {
            LinkedHashMap m = new LinkedHashMap(this.ts);
            return m.keySet().iterator();
        }
        HashMap m = new HashMap(this.ts);
        return m.keySet().iterator();
    }

    public void stop(Object k, Date d) {
        Timing t = (Timing)this.ts.get(k);
        if (t != null) {
            t.stop(d);
        }
    }

    public void stop(Object k, long d) {
        Timing t = (Timing)this.ts.get(k);
        if (t != null) {
            t.stop(d);
        }
    }

    public void stop(Object k) {
        Timing t = (Timing)this.ts.get(k);
        if (t != null) {
            t.stop();
        }
    }

    public void start(Object k) {
        Timing t = (Timing)this.ts.get(k);
        if (t == null) {
            t = new Timing();
            this.ts.put(k, t);
        }
    }

    public void start(Object k, long s) {
        Timing t = (Timing)this.ts.get(k);
        if (t == null) {
            t = new Timing(s);
            this.ts.put(k, t);
        }
    }

    public Timing remove(Object k) {
        return (Timing)this.ts.remove(k);
    }

    public Timing get(Object k) {
        return (Timing)this.ts.get(k);
    }

    public TimeDuration getDuration(Object k) {
        Timing t = this.get(k);
        if (t == null) {
            return null;
        }
        return t.getDuration();
    }

    public long getDurationAsLong(Object k) {
        Timing t = this.get(k);
        if (t == null) {
            return 0L;
        }
        return t.getDuration().rollUpToMillis();
    }

    public void start(Object k, Date s) {
        Timing t = (Timing)this.ts.get(k);
        if (t == null) {
            t = new Timing(s);
            this.ts.put(k, t);
        }
    }
}

