/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class CombinedHash
implements Digest {
    private Digest md5 = new MD5Digest();
    private Digest sha1 = new SHA1Digest();

    public String getAlgorithmName() {
        return this.md5.getAlgorithmName() + " and " + this.sha1.getAlgorithmName() + " for TLS 1.0";
    }

    public int getDigestSize() {
        return 36;
    }

    public void update(byte in) {
        this.md5.update(in);
        this.sha1.update(in);
    }

    public void update(byte[] in, int inOff, int len) {
        this.md5.update(in, inOff, len);
        this.sha1.update(in, inOff, len);
    }

    public int doFinal(byte[] out, int outOff) {
        int i1 = this.md5.doFinal(out, outOff);
        int i2 = this.sha1.doFinal(out, outOff + 16);
        return i1 + i2;
    }

    public void reset() {
        this.md5.reset();
        this.sha1.reset();
    }
}

