/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.tls.TlsCipherSuite;
import org.bouncycastle.crypto.tls.TlsMac;
import org.bouncycastle.crypto.tls.TlsProtocolHandler;
import org.bouncycastle.crypto.tls.TlsUtils;

public class TlsBlockCipherCipherSuite
extends TlsCipherSuite {
    private BlockCipher encryptCipher;
    private BlockCipher decryptCipher;
    private Digest writeDigest;
    private Digest readDigest;
    private int cipherKeySize;
    private short keyExchange;
    private TlsMac writeMac;
    private TlsMac readMac;

    protected TlsBlockCipherCipherSuite(BlockCipher encrypt, BlockCipher decrypt, Digest writeDigest, Digest readDigest, int cipherKeySize, short keyExchange) {
        this.encryptCipher = encrypt;
        this.decryptCipher = decrypt;
        this.writeDigest = writeDigest;
        this.readDigest = readDigest;
        this.cipherKeySize = cipherKeySize;
        this.keyExchange = keyExchange;
    }

    protected void init(byte[] ms, byte[] cr, byte[] sr) {
        int prfSize = 2 * this.cipherKeySize + 2 * this.writeDigest.getDigestSize() + 2 * this.encryptCipher.getBlockSize();
        byte[] key_block = new byte[prfSize];
        byte[] random = new byte[cr.length + sr.length];
        System.arraycopy(cr, 0, random, sr.length, cr.length);
        System.arraycopy(sr, 0, random, 0, sr.length);
        TlsUtils.PRF(ms, TlsUtils.toByteArray("key expansion"), random, key_block);
        int offset = 0;
        this.writeMac = new TlsMac(this.writeDigest, key_block, offset, this.writeDigest.getDigestSize());
        this.readMac = new TlsMac(this.readDigest, key_block, offset += this.writeDigest.getDigestSize(), this.readDigest.getDigestSize());
        this.initCipher(true, this.encryptCipher, key_block, this.cipherKeySize, offset += this.readDigest.getDigestSize(), offset + this.cipherKeySize * 2);
        this.initCipher(false, this.decryptCipher, key_block, this.cipherKeySize, offset += this.cipherKeySize, offset + this.cipherKeySize + this.decryptCipher.getBlockSize());
    }

    private void initCipher(boolean forEncryption, BlockCipher cipher, byte[] key_block, int key_size, int key_offset, int iv_offset) {
        KeyParameter key_parameter = new KeyParameter(key_block, key_offset, key_size);
        ParametersWithIV parameters_with_iv = new ParametersWithIV(key_parameter, key_block, iv_offset, cipher.getBlockSize());
        cipher.init(forEncryption, parameters_with_iv);
    }

    protected byte[] encodePlaintext(short type, byte[] plaintext, int offset, int len) {
        int i;
        int blocksize = this.encryptCipher.getBlockSize();
        int paddingsize = blocksize - (len + this.writeMac.getSize() + 1) % blocksize;
        int totalsize = len + this.writeMac.getSize() + paddingsize + 1;
        byte[] outbuf = new byte[totalsize];
        System.arraycopy(plaintext, offset, outbuf, 0, len);
        byte[] mac = this.writeMac.calculateMac(type, plaintext, offset, len);
        System.arraycopy(mac, 0, outbuf, len, mac.length);
        int paddoffset = len + mac.length;
        for (i = 0; i <= paddingsize; ++i) {
            outbuf[i + paddoffset] = (byte)paddingsize;
        }
        for (i = 0; i < totalsize; i += blocksize) {
            this.encryptCipher.processBlock(outbuf, i, outbuf, i);
        }
        return outbuf;
    }

    protected byte[] decodeCiphertext(short type, byte[] ciphertext, int offset, int len, TlsProtocolHandler handler) throws IOException {
        int blocksize = this.decryptCipher.getBlockSize();
        boolean decrypterror = false;
        for (int i = 0; i < len; i += blocksize) {
            this.decryptCipher.processBlock(ciphertext, i + offset, ciphertext, i + offset);
        }
        int paddingsize = ciphertext[offset + len - 1];
        if (offset + len - 1 - paddingsize < 0) {
            decrypterror = true;
            paddingsize = 0;
        } else {
            for (int i = 0; i <= paddingsize; ++i) {
                if (ciphertext[offset + len - 1 - i] == paddingsize) continue;
                decrypterror = true;
            }
        }
        int plaintextlength = len - this.readMac.getSize() - paddingsize - 1;
        byte[] calculatedMac = this.readMac.calculateMac(type, ciphertext, offset, plaintextlength);
        for (int i = 0; i < calculatedMac.length; ++i) {
            if (ciphertext[offset + plaintextlength + i] == calculatedMac[i]) continue;
            decrypterror = true;
        }
        if (decrypterror) {
            handler.failWithError((short)2, (short)20);
        }
        byte[] plaintext = new byte[plaintextlength];
        System.arraycopy(ciphertext, offset, plaintext, 0, plaintextlength);
        return plaintext;
    }

    protected short getKeyExchangeAlgorithm() {
        return this.keyExchange;
    }
}

