/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import subzero.lib.io.CopyFrom;
import subzero.lib.io.FileEntryImpl;
import subzero.lib.io.ICopyFrom;
import subzero.lib.io.IFileEntry;

public class CopyFromLocal
extends CopyFrom {
    private final File m_file;

    public CopyFromLocal(String from) {
        super(from);
        this.m_file = new File(this.getFrom());
    }

    public CopyFromLocal(File from) {
        super(from.getAbsolutePath());
        this.m_file = from;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = this.getInputStream();
        try {
            byte[] buffer = new byte[16384];
            int numread = 0;
            while (0 <= (numread = in.read(buffer))) {
                baos.write(buffer, 0, numread);
            }
        }
        finally {
            in.close();
            baos.close();
        }
        return baos.toByteArray();
    }

    public int length() {
        return (int)this.m_file.length();
    }

    public boolean supportStreaming() {
        return true;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.m_file);
    }

    public InputStream getInputStream(IFileEntry child) throws IOException {
        return new FileInputStream(this.getFile(child));
    }

    private File getFile(IFileEntry entry) throws IOException {
        if (entry.getParent() instanceof ICopyFrom) {
            return this.m_file;
        }
        if (entry.getParent() instanceof IFileEntry) {
            return new File(this.getFile((IFileEntry)entry.getParent()), entry.getName());
        }
        throw new IOException("Unexpected parent type [" + entry.getClass().getName());
    }

    public Class getInterfaceClass() {
        return ICopyFrom.class;
    }

    public IFileEntry getFileEntry() {
        return new FileEntryImpl(this, this.m_file);
    }
}

