/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import subzero.lib.io.IOConnection;

public class LoggingIOConnection
implements IOConnection {
    protected static final Logger log = Logger.getLogger((String)"LOGGINGIO");
    private IOConnection m_ioConnection;
    private final InputStream m_loggingIn;
    private final OutputStream m_loggingOut;
    private volatile boolean m_isOutputLogging = true;
    private volatile boolean m_isInputLogging = true;
    protected Level m_loggingLevel = Level.DEBUG;
    protected Logger m_categoryLogger;

    public LoggingIOConnection(IOConnection connection, String category) {
        this.m_ioConnection = connection;
        this.m_loggingIn = new LoggingInputStream();
        this.m_loggingOut = new LoggingOutputStream();
        this.m_categoryLogger = Logger.getLogger((String)("PASSTHRU." + category));
    }

    public void setLevel(Level level) {
        this.m_loggingLevel = level;
    }

    public String getConnectionName() {
        return this.m_ioConnection.getConnectionName();
    }

    public InputStream getInputStream() {
        return this.m_loggingIn;
    }

    public OutputStream getOutputStream() {
        return this.m_loggingOut;
    }

    public void close() throws IOException {
        this.m_ioConnection.close();
    }

    public boolean isClosed() {
        return this.m_ioConnection.isClosed();
    }

    public String readRemaining() {
        StringBuffer buf = new StringBuffer();
        InputStream in = this.getInputStream();
        try {
            int read;
            while ((read = in.read()) != -1) {
                buf.append((char)read);
            }
            return buf.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return buf.toString();
        }
    }

    public void skipRemaining() {
        InputStream in = this.getInputStream();
        try {
            int read;
            while ((read = in.read()) != -1) {
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setOutputLoggingEnabled(boolean enabled) {
        this.m_isOutputLogging = enabled;
    }

    public void setInputLoggingEnabled(boolean enabled) {
        if (!enabled) {
            log.debug((Object)"\n>> Connection logging temporarily suspended.<<\n");
        }
        this.m_isInputLogging = enabled;
    }

    private final class LoggingOutputStream
    extends OutputStream {
        private final OutputStream m_out;

        private LoggingOutputStream() {
            this.m_out = LoggingIOConnection.this.m_ioConnection.getOutputStream();
        }

        public void close() throws IOException {
            LoggingIOConnection.this.m_ioConnection.close();
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (LoggingIOConnection.this.m_isOutputLogging) {
                LoggingIOConnection.this.m_categoryLogger.log((Priority)LoggingIOConnection.this.m_loggingLevel, (Object)new String(b, off, len));
            }
            this.m_out.write(b, off, len);
        }

        public void write(int b) throws IOException {
            if (LoggingIOConnection.this.m_isOutputLogging) {
                LoggingIOConnection.this.m_categoryLogger.log((Priority)LoggingIOConnection.this.m_loggingLevel, (Object)String.valueOf((char)b));
            }
            this.m_out.write(b);
        }

        public void flush() throws IOException {
            this.m_out.flush();
        }
    }

    private final class LoggingInputStream
    extends InputStream {
        private final InputStream m_in;

        private LoggingInputStream() {
            this.m_in = LoggingIOConnection.this.m_ioConnection.getInputStream();
        }

        public void close() throws IOException {
            LoggingIOConnection.this.m_ioConnection.close();
        }

        public int read() throws IOException {
            int data = this.m_in.read();
            if (LoggingIOConnection.this.m_isInputLogging && data != -1) {
                LoggingIOConnection.this.m_categoryLogger.log((Priority)LoggingIOConnection.this.m_loggingLevel, (Object)String.valueOf((char)data));
            }
            return data;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int numRead = this.m_in.read(b, off, len);
            if (LoggingIOConnection.this.m_isInputLogging && numRead > 0) {
                LoggingIOConnection.this.m_categoryLogger.log((Priority)LoggingIOConnection.this.m_loggingLevel, (Object)new String(b, off, numRead));
            }
            return numRead;
        }
    }
}

