/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import subzero.lib.exceptions.SSHRuntimeException;
import subzero.lib.io.IFileEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFTPFileEntry
implements IFileEntry {
    private final String m_path;
    private final ChannelSftp m_sftp;
    private final Object m_parent;
    private final String m_name;
    private List<IFileEntry> m_children = null;
    private boolean m_isDirectory = false;
    private boolean m_exists = false;

    public SFTPFileEntry(ChannelSftp sftp, Object parent, String path) {
        String name;
        this.m_parent = parent;
        path = path.replace('\\', '/');
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() == 0) {
            path = "/";
            name = ".";
        } else {
            name = path.substring(path.lastIndexOf("/") + 1);
        }
        this.m_name = name;
        this.m_path = path;
        this.m_sftp = sftp;
    }

    private SFTPFileEntry(SFTPFileEntry parent, String path, String name) {
        this.m_sftp = parent.m_sftp;
        this.m_name = name;
        this.m_path = path;
        this.m_parent = parent;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getPath() {
        if (this.isDirectory()) {
            return this.m_path + "/";
        }
        return this.m_path;
    }

    @Override
    public String getSystemPath() {
        return this.m_path;
    }

    @Override
    public long getLastModified() {
        try {
            SftpATTRS attrs = this.m_sftp.stat(this.m_path);
            return attrs.getMTime();
        }
        catch (SftpException e) {
            return -1L;
        }
    }

    @Override
    public long getLength() {
        try {
            SftpATTRS attrs = this.m_sftp.stat(this.m_path);
            if (attrs.isDir()) {
                return 0L;
            }
            return attrs.getSize();
        }
        catch (SftpException e) {
            return -1L;
        }
    }

    @Override
    public boolean exists() {
        if (this.m_exists) {
            return this.m_exists;
        }
        try {
            this.m_sftp.stat(this.m_path);
            this.m_exists = true;
            return this.m_exists;
        }
        catch (SftpException e) {
            return false;
        }
    }

    @Override
    public boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    public boolean isDirectory() {
        if (this.m_isDirectory) {
            return true;
        }
        try {
            SftpATTRS attrs = this.m_sftp.stat(this.m_path);
            this.m_isDirectory = attrs.isDir();
            return this.m_isDirectory;
        }
        catch (SftpException e) {
            return false;
        }
    }

    @Override
    public List<IFileEntry> getChildren() {
        if (!this.isDirectory()) {
            return null;
        }
        if (this.m_children != null) {
            return this.m_children;
        }
        try {
            Vector list = this.m_sftp.ls(this.m_path);
            if (list == null) {
                throw new SSHRuntimeException("No files found [" + this.m_path + "]");
            }
            String path = this.m_path;
            if (path.length() > 1) {
                path = path + "/";
            }
            this.m_children = new ArrayList<IFileEntry>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                String entry = String.valueOf(list.get(i));
                StringTokenizer tokens = new StringTokenizer(entry, " ");
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                String name = tokens.nextToken();
                if (".".equals(name) || "..".equals(name)) continue;
                this.m_children.add(new SFTPFileEntry(this, path + name, name));
            }
            return this.m_children;
        }
        catch (SftpException e) {
            System.err.println("getChildren() exception:");
            System.err.println(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<IFileEntry> getChildren(boolean refresh) {
        if (refresh) {
            this.m_children = null;
        }
        return this.getChildren();
    }

    @Override
    public Object getParent() {
        return this.m_parent;
    }

    @Override
    public IFileEntry newChild(String name) {
        if (!this.isDirectory()) {
            return null;
        }
        List<IFileEntry> children = this.getChildren();
        if (children == null) {
            throw new SSHRuntimeException("ls error on [" + this.getPath() + "]");
        }
        for (IFileEntry child : children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        String path = this.m_path;
        if (path.length() > 1) {
            path = path + "/";
        }
        SFTPFileEntry newChild = new SFTPFileEntry(this, path + name, name);
        this.m_children.add(newChild);
        return newChild;
    }

    public ChannelSftp getChannelSftp() {
        return this.m_sftp;
    }
}

