/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import subzero.lib.exceptions.IOTimeoutException;
import subzero.lib.io.AbstractIOConnection;
import subzero.lib.io.IOCommands;
import subzero.lib.io.RegexConnection;
import subzero.lib.io.TelnetConnectionProtocolHandler;
import subzero.lib.io.TelnetInputStream;
import subzero.lib.io.TelnetOutputStream;
import subzero.lib.util.TimeUtil;

public class TelnetConnection
extends AbstractIOConnection {
    private static Logger s_logger = Logger.getLogger(TelnetConnection.class);
    public static final int DEFAULT_PORT = 23;
    public static int TELNET_CON_TIMEOUT = 30;
    private final String m_connectionName;
    private final TelnetConnectionProtocolHandler m_handler;
    private InputStream m_tinp;
    private OutputStream m_tout;
    protected final Socket m_socket;

    public static void setTELNET_CON_TIMEOUT(int telnet_con_timeout) {
        TELNET_CON_TIMEOUT = telnet_con_timeout;
    }

    public TelnetConnection(String host) throws IOException {
        this(host, 23);
    }

    public TelnetConnection(String host, int port) throws IOException {
        this(host, port, false);
    }

    public TelnetConnection(String host, int port, boolean doInit) throws IOException {
        this.m_connectionName = "telnet[" + host + ":" + port + "]";
        this.m_socket = new Socket(host, port);
        this.m_handler = new TelnetConnectionProtocolHandler(this.m_socket);
        this.m_handler.reset();
        this.m_tinp = new TelnetInputStream(this.m_handler);
        this.m_tout = new TelnetOutputStream(this.m_handler);
        String doIt = System.getProperty("doTelnetInit");
        if (doIt != null && doIt.equalsIgnoreCase("true")) {
            doInit = true;
        }
        s_logger.debug((Object)("Telneting to " + host + ":" + port + ", doTelnetInit => " + doInit));
        if (doInit) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ((TelnetInputStream)TelnetConnection.this.m_tinp).initNegociation(new byte[1024], TelnetConnection.this.m_socket.toString());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            thread.start();
            long endTimeMillis = System.currentTimeMillis() + 5000L;
            while (thread.isAlive() && System.currentTimeMillis() <= endTimeMillis) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException t) {
                    s_logger.error((Object)"Interrupted while sleeping", (Throwable)t);
                }
            }
            TimeUtil.sleep(3000);
        }
    }

    public TelnetConnection(String host, String username, String password) throws IOException, IOTimeoutException {
        this(host, 23, username, password, IOCommands.LF);
    }

    public TelnetConnection(String host, String username, String password, IOCommands rc) throws IOException, IOTimeoutException {
        this(host, 23, username, password, rc);
    }

    public TelnetConnection(String host, int port, String username, String password, IOCommands rc) throws IOException, IOTimeoutException {
        this(host, port, username, password, rc, false);
    }

    public TelnetConnection(String host, int port, String username, String password, IOCommands rc, boolean doInit) throws IOException, IOTimeoutException {
        this(host, port, doInit);
        s_logger.debug((Object)("Auth: (" + username + "/" + password + ") " + rc.name()));
        this.setReturnCharacter(rc);
        RegexConnection regex = new RegexConnection(this);
        Pattern loginPattern = Pattern.compile("(login)|(username).", 2);
        Pattern passwordPattern = Pattern.compile("password.", 2);
        regex.readUntilRegex(loginPattern, (long)(TELNET_CON_TIMEOUT * 1000));
        regex.sendText(username + (Object)((Object)this.m_returnChar));
        regex.readUntilRegex(passwordPattern, (long)(TELNET_CON_TIMEOUT * 1000));
        regex.sendText(password + (Object)((Object)this.m_returnChar));
    }

    public String getConnectionName() {
        return this.m_connectionName;
    }

    public InputStream getInputStream() {
        return this.m_tinp;
    }

    public OutputStream getOutputStream() {
        return this.m_tout;
    }

    public void sendUrgentDatatoSocket(int i) throws IOException {
        this.m_socket.sendUrgentData(i);
    }

    public void close() throws IOException {
        this.m_socket.close();
    }

    public boolean isClosed() {
        return this.m_socket.isClosed();
    }
}

