/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Timer;
import java.util.TimerTask;
import subzero.lib.io.Timeout;

public class TimeoutInputStream
extends InputStream {
    private final InputStream _in;
    private static final Timer _timer = new Timer(true);
    private volatile long _timeout;
    private final Timeout _timeoutobj;
    protected volatile boolean _ioInterrupted = false;
    protected volatile long m_stopTime = -1L;

    public TimeoutInputStream(InputStream in, long initialTimeout) {
        this._in = in;
        this.setReadTimeout(initialTimeout);
        this._timeoutobj = new Timeout(this);
        _timer.scheduleAtFixedRate((TimerTask)this._timeoutobj, 50L, 50L);
    }

    public synchronized void setReadTimeout(long timeout) {
        if (timeout <= 0L) {
            this._timeout = -1L;
            return;
        }
        this._timeout = timeout;
    }

    public long getReadTimeout() {
        return this._timeout;
    }

    public synchronized int read() throws IOException {
        this._ioInterrupted = false;
        int retValue = -1;
        try {
            this.m_stopTime = this.calculateStopTime();
            try {
                retValue = this._in.read();
            }
            finally {
                this.m_stopTime = -1L;
            }
        }
        catch (IOException ioe) {
            if (this._ioInterrupted) {
                throw new InterruptedIOException(ioe.getMessage());
            }
            throw ioe;
        }
        finally {
            if (this._ioInterrupted) {
                throw new InterruptedIOException("The read operation did not complete within the " + this._timeout + "ms timeout");
            }
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        this._ioInterrupted = false;
        int retValue = -1;
        try {
            this.m_stopTime = this.calculateStopTime();
            try {
                retValue = this._in.read(buf, off, len);
            }
            finally {
                this.m_stopTime = -1L;
            }
        }
        catch (IOException ioe) {
            if (this._ioInterrupted) {
                throw new InterruptedIOException(ioe.getMessage());
            }
            throw ioe;
        }
        finally {
            if (this._ioInterrupted) {
                throw new InterruptedIOException("The read operation did not complete within the " + this._timeout + "ms timeout");
            }
        }
        return retValue;
    }

    public final synchronized int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int available() throws IOException {
        return this._in.available();
    }

    public void close() throws IOException {
        this._timeoutobj.cancel();
        this._in.close();
    }

    public void mark(int readLimit) {
        this._in.mark(readLimit);
    }

    public boolean markSupported() {
        return this._in.markSupported();
    }

    public void reset() throws IOException {
        this._in.reset();
    }

    public long skip(long n) throws IOException {
        return this._in.skip(n);
    }

    protected synchronized long calculateStopTime() {
        long readTimeout = this.getReadTimeout();
        if (readTimeout < 0L) {
            return -1L;
        }
        long now = System.currentTimeMillis();
        long stopTime = now + readTimeout;
        if (stopTime <= now) {
            return Long.MAX_VALUE;
        }
        return stopTime;
    }
}

