/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import javax.annotation.Nonnull;
import mockit.coverage.CodeCoverage;
import mockit.coverage.Configuration;

public enum Metrics {
    LineCoverage("Line", "Line segments", "Measures how much of the executable production code was exercised by tests.\r\nAn executable line of code contains one or more executable segments.\r\nThe percentages are calculated as 100*NE/NS, where NS is the number of segments and NE the number of executed segments.", Metrics.isActive("line")),
    PathCoverage("Path", "Paths", "Measures how many of the possible execution paths through method/constructor bodies were actually executed by tests.\r\nThe percentages are calculated as 100*NPE/NP, where NP is the number of possible paths and NPE the number of fully executed paths.", Metrics.isActive("path")),
    DataCoverage("Data", "Fields", "Measures how many of the instance and static non-final fields were fully exercised by the test run.\r\nTo be fully exercised, a field must have the last value assigned to it read by at least one test.\r\nThe percentages are calculated as 100*NFE/NF, where NF is the number of non-final fields and NFE the number of fully exercised fields.", CodeCoverage.isTestRun() && Metrics.isActive("data"));

    @Nonnull
    private final String name;
    @Nonnull
    public final String itemName;
    @Nonnull
    public final String htmlDescription;
    public final boolean active;

    private static boolean isActive(@Nonnull String name) {
        String metrics = Configuration.getProperty("metrics", "line");
        boolean all = "all".equals(metrics);
        return all || metrics.contains(name);
    }

    private Metrics(@Nonnull String name, String itemName, String htmlDescription, boolean active) {
        this.name = name;
        this.itemName = itemName;
        this.htmlDescription = htmlDescription;
        this.active = active;
    }

    public String toString() {
        return this.name;
    }

    public static void performAction(@Nonnull Action action) {
        for (Metrics metric : Metrics.values()) {
            if (!metric.active) continue;
            action.perform(metric);
        }
    }

    public static interface Action {
        public void perform(@Nonnull Metrics var1);
    }
}

