/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.data;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.CoveragePercentage;
import mockit.coverage.Metrics;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.data.PerFileCoverage;

public final class CoverageData
implements Serializable {
    private static final long serialVersionUID = -4860004226098360259L;
    @Nonnull
    private static final CoverageData instance = new CoverageData();
    private boolean withCallPoints;
    @Nonnull
    private final Map<String, FileCoverageData> fileToFileData = new LinkedHashMap<String, FileCoverageData>();
    @Nonnull
    private final List<FileCoverageData> indexedFileData = new ArrayList<FileCoverageData>(100);

    @Nonnull
    public static CoverageData instance() {
        return instance;
    }

    public boolean isWithCallPoints() {
        return this.withCallPoints;
    }

    public void setWithCallPoints(boolean withCallPoints) {
        this.withCallPoints = withCallPoints;
    }

    @Nonnull
    public Map<String, FileCoverageData> getRawFileToFileData() {
        return this.fileToFileData;
    }

    @Nonnull
    public Map<String, FileCoverageData> getFileToFileDataMap() {
        LinkedHashMap<String, FileCoverageData> copy = new LinkedHashMap<String, FileCoverageData>(this.fileToFileData);
        Iterator itr = copy.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry fileAndFileData = itr.next();
            FileCoverageData fileData = (FileCoverageData)fileAndFileData.getValue();
            if (fileData.getTotalItemsForAllMetrics() != 0) continue;
            itr.remove();
        }
        return Collections.unmodifiableMap(copy);
    }

    @Nonnull
    public FileCoverageData getOrAddFile(@Nonnull String file, @Nullable String kindOfTopLevelType) {
        FileCoverageData fileData = this.fileToFileData.get(file);
        if (fileData == null) {
            int fileIndex = this.indexedFileData.size();
            fileData = new FileCoverageData(fileIndex, kindOfTopLevelType);
            this.indexedFileData.add(fileData);
            this.fileToFileData.put(file, fileData);
        } else if (kindOfTopLevelType != null) {
            fileData.kindOfTopLevelType = kindOfTopLevelType;
        }
        return fileData;
    }

    @Nonnull
    public FileCoverageData getFileData(@Nonnull String file) {
        return this.fileToFileData.get(file);
    }

    @Nonnull
    public FileCoverageData getFileData(int fileIndex) {
        return this.indexedFileData.get(fileIndex);
    }

    public boolean isEmpty() {
        return this.fileToFileData.isEmpty();
    }

    public void clear() {
        this.fileToFileData.clear();
    }

    public int getPercentage(@Nonnull Metrics metric, @Nullable String fileNamePrefix) {
        int coveredItems = 0;
        int totalItems = 0;
        for (Map.Entry<String, FileCoverageData> fileAndFileData : this.fileToFileData.entrySet()) {
            String sourceFile = fileAndFileData.getKey();
            if (fileNamePrefix != null && !sourceFile.startsWith(fileNamePrefix)) continue;
            FileCoverageData fileData = fileAndFileData.getValue();
            PerFileCoverage coverageInfo = fileData.getPerFileCoverage(metric);
            coveredItems += coverageInfo.getCoveredItems();
            totalItems += coverageInfo.getTotalItems();
        }
        return CoveragePercentage.calculate(coveredItems, totalItems);
    }

    public int getSmallestPerFilePercentage(@Nonnull Metrics metric) {
        int minPercentage = Integer.MAX_VALUE;
        for (FileCoverageData fileData : this.fileToFileData.values()) {
            PerFileCoverage coverageInfo;
            int percentage;
            if (fileData.wasLoadedAfterTestCompletion() || (percentage = (coverageInfo = fileData.getPerFileCoverage(metric)).getCoveragePercentage()) < 0 || percentage >= minPercentage) continue;
            minPercentage = percentage;
        }
        return minPercentage;
    }

    public void reset() {
        for (FileCoverageData fileCoverageData : this.fileToFileData.values()) {
            fileCoverageData.reset();
        }
    }

    public void fillLastModifiedTimesForAllClassFiles() {
        Iterator<Map.Entry<String, FileCoverageData>> itr = this.fileToFileData.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, FileCoverageData> fileAndFileData = itr.next();
            long lastModified = this.getLastModifiedTimeForClassFile(fileAndFileData.getKey());
            if (lastModified > 0L) {
                FileCoverageData fileCoverageData = fileAndFileData.getValue();
                fileCoverageData.lastModified = lastModified;
                continue;
            }
            itr.remove();
        }
    }

    private long getLastModifiedTimeForClassFile(@Nonnull String sourceFilePath) {
        String sourceFilePathNoExt = sourceFilePath.substring(0, sourceFilePath.lastIndexOf(46));
        String className = sourceFilePathNoExt.replace('/', '.');
        Class<?> coveredClass = this.findCoveredClass(className);
        if (coveredClass == null) {
            return 0L;
        }
        String locationPath = coveredClass.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (locationPath.endsWith(".jar")) {
            try {
                return CoverageData.getLastModifiedTimeFromJarEntry(sourceFilePathNoExt, locationPath);
            }
            catch (IOException ignore) {
                return 0L;
            }
        }
        String pathToClassFile = locationPath + sourceFilePathNoExt + ".class";
        return new File(pathToClassFile).lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getLastModifiedTimeFromJarEntry(@Nonnull String sourceFilePathNoExt, @Nonnull String locationPath) throws IOException {
        JarFile jarFile = new JarFile(locationPath);
        try {
            JarEntry classEntry = jarFile.getJarEntry(sourceFilePathNoExt + ".class");
            long l = classEntry.getTime();
            return l;
        }
        finally {
            jarFile.close();
        }
    }

    @Nullable
    private Class<?> findCoveredClass(@Nonnull String className) {
        ClassLoader currentCL = this.getClass().getClassLoader();
        Class<?> coveredClass = CoverageData.loadClass(className, currentCL);
        if (coveredClass == null) {
            ClassLoader contextCL;
            ClassLoader systemCL = ClassLoader.getSystemClassLoader();
            if (systemCL != currentCL) {
                coveredClass = CoverageData.loadClass(className, systemCL);
            }
            if (coveredClass == null && (contextCL = Thread.currentThread().getContextClassLoader()) != null && contextCL != systemCL) {
                coveredClass = CoverageData.loadClass(className, contextCL);
            }
        }
        return coveredClass;
    }

    @Nullable
    private static Class<?> loadClass(@Nonnull String className, @Nullable ClassLoader loader) {
        try {
            return Class.forName(className, false, loader);
        }
        catch (ClassNotFoundException ignore) {
            return null;
        }
        catch (NoClassDefFoundError ignored) {
            return null;
        }
    }

    @Nonnull
    public static CoverageData readDataFromFile(@Nonnull File dataFile) throws IOException {
        ObjectInputStream input = new ObjectInputStream(new BufferedInputStream(new FileInputStream(dataFile)));
        try {
            CoverageData coverageData = (CoverageData)input.readObject();
            return coverageData;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Serialized class in coverage data file \"" + dataFile + "\" not found in classpath", e);
        }
        finally {
            input.close();
        }
    }

    public void writeDataToFile(@Nonnull File dataFile) throws IOException {
        ObjectOutputStream output = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(dataFile)));
        try {
            output.writeObject(this);
        }
        finally {
            output.close();
        }
    }

    public void merge(@Nonnull CoverageData previousData) {
        this.withCallPoints |= previousData.withCallPoints;
        for (Map.Entry<String, FileCoverageData> previousFileAndFileData : previousData.fileToFileData.entrySet()) {
            String previousFile = previousFileAndFileData.getKey();
            FileCoverageData previousFileData = previousFileAndFileData.getValue();
            FileCoverageData fileData = this.fileToFileData.get(previousFile);
            if (fileData == null) {
                this.fileToFileData.put(previousFile, previousFileData);
                continue;
            }
            if (fileData.lastModified <= 0L || previousFileData.lastModified != fileData.lastModified) continue;
            fileData.mergeWithDataFromPreviousTestRun(previousFileData);
        }
    }
}

