/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.modification;

import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.CodeCoverage;
import mockit.coverage.Configuration;
import mockit.internal.util.ClassLoad;

final class ClassSelection {
    private static final String THIS_CLASS_NAME = ClassSelection.class.getName();
    private static final ClassLoader THIS_CLASS_LOADER = ClassSelection.class.getClassLoader();
    private static final Pattern CSV = Pattern.compile(",");
    private static final Pattern DOT = Pattern.compile("\\.");
    private static final Pattern STAR = Pattern.compile("\\*");
    private static final Pattern TEST_CLASS_NAME = Pattern.compile(".+Test(\\$.+)?");
    boolean loadedOnly;
    @Nullable
    private Matcher classesToInclude;
    @Nullable
    private Matcher classesToExclude;
    @Nullable
    private final Matcher testCode;
    private boolean configurationRead;

    ClassSelection() {
        if (CodeCoverage.isTestRun()) {
            this.testCode = TEST_CLASS_NAME.matcher("");
        } else {
            this.testCode = null;
            this.readConfiguration();
        }
    }

    @Nullable
    private static Matcher newMatcherForClassSelection(@Nonnull String specification) {
        if (specification.isEmpty()) {
            return null;
        }
        String[] specs = CSV.split(specification);
        StringBuilder finalRegexBuilder = new StringBuilder();
        String sep = "";
        for (String spec : specs) {
            String regex = null;
            if (spec.indexOf(92) >= 0) {
                regex = spec;
            } else if (!spec.isEmpty()) {
                regex = DOT.matcher(spec).replaceAll("\\.");
                regex = STAR.matcher(regex).replaceAll(".*");
                regex = regex.replace('?', '.');
            }
            if (regex == null) continue;
            finalRegexBuilder.append(sep).append(regex);
            sep = "|";
        }
        String finalRegex = finalRegexBuilder.toString();
        return finalRegex.isEmpty() ? null : Pattern.compile(finalRegex).matcher("");
    }

    boolean isSelected(@Nonnull String className, @Nonnull ProtectionDomain protectionDomain) {
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null || ClassSelection.isIneligibleForSelection(className) || !ClassSelection.canAccessJMockitFromClassToBeMeasured(protectionDomain)) {
            return false;
        }
        URL location = ClassSelection.findLocationInCodeSource(className, protectionDomain);
        if (location == null) {
            return false;
        }
        if (!this.configurationRead) {
            this.readConfiguration();
        }
        if (this.isClassExcludedFromCoverage(className)) {
            return false;
        }
        if (this.classesToInclude != null) {
            return this.classesToInclude.reset(className).matches();
        }
        return !this.isClassFromExternalLibrary(location);
    }

    private static boolean isIneligibleForSelection(@Nonnull String className) {
        return className.charAt(0) == '[' || className.startsWith("mockit.") || className.contains(".attach.") || className.startsWith("org.hamcrest.") || className.startsWith("org.junit.") || className.startsWith("junit.") || className.startsWith("org.testng.") || className.startsWith("org.apache.maven.surefire.") || ClassLoad.isGeneratedSubclass(className);
    }

    private static boolean canAccessJMockitFromClassToBeMeasured(@Nonnull ProtectionDomain protectionDomain) {
        ClassLoader loaderOfClassToBeMeasured = protectionDomain.getClassLoader();
        if (loaderOfClassToBeMeasured != null) {
            try {
                Class<?> thisClass = loaderOfClassToBeMeasured.loadClass(THIS_CLASS_NAME);
                return thisClass == ClassSelection.class;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    @Nullable
    private static URL findLocationInCodeSource(@Nonnull String className, @Nonnull ProtectionDomain protectionDomain) {
        URL location = protectionDomain.getCodeSource().getLocation();
        if (location == null) {
            if (protectionDomain.getClassLoader() == THIS_CLASS_LOADER) {
                return null;
            }
            String classFileName = className.replace('.', '/') + ".class";
            location = THIS_CLASS_LOADER.getResource(classFileName);
        }
        return location;
    }

    private boolean isClassExcludedFromCoverage(@Nonnull String className) {
        return this.classesToExclude != null && this.classesToExclude.reset(className).matches() || this.testCode != null && this.testCode.reset(className).matches();
    }

    private boolean isClassFromExternalLibrary(@Nonnull URL location) {
        if ("jar".equals(location.getProtocol())) {
            return true;
        }
        String path = location.getPath();
        return path.endsWith(".jar") || path.endsWith("/.cp/") || this.testCode != null && path.endsWith("/test-classes/");
    }

    private void readConfiguration() {
        String classes = Configuration.getProperty("classes", "");
        this.loadedOnly = "loaded".equals(classes);
        this.classesToInclude = this.loadedOnly ? null : ClassSelection.newMatcherForClassSelection(classes);
        String excludes = Configuration.getProperty("excludes", "");
        this.classesToExclude = ClassSelection.newMatcherForClassSelection(excludes);
        this.configurationRead = true;
    }
}

