/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.junit4.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Invocation;
import mockit.Mock;
import mockit.MockUp;
import mockit.integration.junit4.internal.JUnit4TestRunnerDecorator;
import mockit.internal.mockups.MockInvocation;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.StackTrace;
import org.junit.runners.model.FrameworkMethod;

public final class MockFrameworkMethod
extends MockUp<FrameworkMethod> {
    @Nonnull
    private final JUnit4TestRunnerDecorator decorator = new JUnit4TestRunnerDecorator();

    public static boolean hasDependenciesInClasspath() {
        return ClassLoad.searchTypeInClasspath("org.junit.runners.model.FrameworkMethod", true) != null;
    }

    @Nullable
    @Mock
    public Object invokeExplosively(@Nonnull Invocation invocation, Object target, Object ... params) throws Throwable {
        return this.decorator.invokeExplosively((MockInvocation)invocation, target, params);
    }

    @Mock
    public static void validatePublicVoidNoArg(@Nonnull Invocation invocation, boolean isStatic, List<Throwable> errors) {
        FrameworkMethod it = (FrameworkMethod)invocation.getInvokedInstance();
        int previousErrorCount = errors.size();
        if (!isStatic && MockFrameworkMethod.eachParameterContainsAMockingAnnotation(it.getMethod().getParameterAnnotations())) {
            it.validatePublicVoid(false, errors);
        } else {
            ((MockInvocation)invocation).prepareToProceedFromNonRecursiveMock();
            it.validatePublicVoidNoArg(isStatic, errors);
        }
        int errorCount = errors.size();
        for (int i = previousErrorCount; i < errorCount; ++i) {
            Throwable errorAdded = errors.get(i);
            StackTrace.filterStackTrace(errorAdded);
        }
    }

    private static boolean eachParameterContainsAMockingAnnotation(@Nonnull Annotation[][] parametersAndTheirAnnotations) {
        if (parametersAndTheirAnnotations.length == 0) {
            return false;
        }
        for (Annotation[] parameterAnnotations : parametersAndTheirAnnotations) {
            if (MockFrameworkMethod.containsAMockingAnnotation(parameterAnnotations)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsAMockingAnnotation(@Nonnull Annotation[] parameterAnnotations) {
        if (parameterAnnotations.length == 0) {
            return false;
        }
        for (Annotation parameterAnnotation : parameterAnnotations) {
            String annotationTypeName = parameterAnnotation.annotationType().getName();
            if ("mockit.Mocked mockit.Injectable mockit.Capturing".contains(annotationTypeName)) continue;
            return false;
        }
        return true;
    }
}

