/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.Type;
import mockit.internal.MissingInvocation;
import mockit.internal.UnexpectedInvocation;
import mockit.internal.expectations.argumentMatching.ArgumentMatcher;
import mockit.internal.expectations.argumentMatching.ArgumentMismatch;
import mockit.internal.expectations.invocation.ExpectationError;
import mockit.internal.expectations.invocation.InvocationArguments;
import mockit.internal.state.MockedTypeCascade;
import mockit.internal.state.TestRun;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.DefaultValues;
import mockit.internal.util.GenericTypeReflection;
import mockit.internal.util.MethodFormatter;
import mockit.internal.util.ObjectMethods;
import mockit.internal.util.StackTrace;
import mockit.internal.util.TypeDescriptor;

public final class ExpectedInvocation {
    @Nonnull
    private static final Object UNDEFINED_DEFAULT_RETURN = new Object();
    @Nullable
    public final Object instance;
    @Nullable
    public Object replacementInstance;
    public boolean matchInstance;
    @Nonnull
    public final InvocationArguments arguments;
    @Nullable
    private final ExpectationError invocationCause;
    @Nullable
    Object defaultReturnValue;

    public ExpectedInvocation(@Nullable Object mock, @Nonnull String mockedClassDesc, @Nonnull String mockNameAndDesc, @Nullable String genericSignature, @Nonnull Object[] args) {
        this.instance = mock;
        this.arguments = new InvocationArguments(0, mockedClassDesc, mockNameAndDesc, genericSignature, args);
        this.invocationCause = null;
        this.defaultReturnValue = this.determineDefaultReturnValueFromMethodSignature();
    }

    public ExpectedInvocation(@Nullable Object mock, int access, @Nonnull String mockedClassDesc, @Nonnull String mockNameAndDesc, boolean matchInstance, @Nullable String genericSignature, @Nonnull Object[] args) {
        this.instance = mock;
        this.matchInstance = matchInstance;
        this.arguments = new InvocationArguments(access, mockedClassDesc, mockNameAndDesc, genericSignature, args);
        this.invocationCause = new ExpectationError();
        this.defaultReturnValue = this.determineDefaultReturnValueFromMethodSignature();
    }

    @Nullable
    public AssertionError getInvocationCause() {
        return this.invocationCause;
    }

    @Nonnull
    private Object determineDefaultReturnValueFromMethodSignature() {
        Object rv;
        if (this.instance != null && (rv = ObjectMethods.evaluateOverride(this.instance, this.getMethodNameAndDescription(), this.getArgumentValues())) != null) {
            return rv;
        }
        return UNDEFINED_DEFAULT_RETURN;
    }

    @Nonnull
    public String getClassDesc() {
        return this.arguments.classDesc;
    }

    @Nonnull
    public String getClassName() {
        return this.arguments.getClassName();
    }

    @Nonnull
    public String getMethodNameAndDescription() {
        return this.arguments.methodNameAndDesc;
    }

    @Nonnull
    public Object[] getArgumentValues() {
        return this.arguments.getValues();
    }

    public boolean isConstructor() {
        return this.arguments.isForConstructor();
    }

    @Nullable
    public Object getRecordedInstance() {
        return this.replacementInstance != null ? this.replacementInstance : this.instance;
    }

    @Nonnull
    public String getSignatureWithResolvedReturnType() {
        String classDesc;
        Class<Object> mockedClass;
        GenericTypeReflection reflection;
        char firstTypeChar;
        String signature = this.arguments.genericSignature;
        if (signature != null && (firstTypeChar = (signature = (reflection = new GenericTypeReflection(mockedClass = this.instance != null ? this.instance.getClass() : ClassLoad.loadByInternalName(classDesc), null)).resolveReturnType(classDesc = this.getClassDesc(), signature)).charAt(signature.indexOf(41) + 1)) != 'T' && firstTypeChar != '[') {
            return signature;
        }
        return this.arguments.methodNameAndDesc;
    }

    public boolean isMatch(@Nullable Object mock, @Nonnull String invokedClassDesc, @Nonnull String invokedMethod) {
        return invokedClassDesc.equals(this.getClassDesc()) && (this.isMatchingGenericMethod(mock, invokedMethod) || this.isMatchingMethod(invokedMethod));
    }

    private boolean isMatchingGenericMethod(@Nullable Object mock, @Nonnull String invokedMethod) {
        Class<?> mockedClass;
        String genericSignature;
        if (mock != null && this.instance != null && (genericSignature = this.arguments.genericSignature) != null && (mockedClass = mock.getClass()) != this.instance.getClass()) {
            GenericTypeReflection typeReflection = new GenericTypeReflection(mockedClass, null);
            GenericTypeReflection.GenericSignature parsedSignature = typeReflection.parseSignature(genericSignature);
            return parsedSignature.satisfiesSignature(invokedMethod);
        }
        return false;
    }

    private boolean isMatchingMethod(@Nonnull String invokedMethod) {
        int returnTypeStartPos = this.getReturnTypePosition(invokedMethod);
        if (returnTypeStartPos < 0) {
            return false;
        }
        if (this.haveSameReturnTypes(invokedMethod, returnTypeStartPos)) {
            return true;
        }
        return this.isReturnTypeOfRecordedMethodAssignableToReturnTypeOfInvokedMethod(invokedMethod, returnTypeStartPos);
    }

    private int getReturnTypePosition(@Nonnull String invokedMethod) {
        char c;
        String recordedMethod = this.getMethodNameAndDescription();
        int i = 0;
        do {
            if ((c = recordedMethod.charAt(i)) != invokedMethod.charAt(i)) {
                return -1;
            }
            ++i;
        } while (c != ')');
        return i;
    }

    private boolean haveSameReturnTypes(@Nonnull String invokedMethod, @Nonnegative int returnTypeStartPos) {
        String recordedMethod = this.getMethodNameAndDescription();
        int n = invokedMethod.length();
        if (n != recordedMethod.length()) {
            return false;
        }
        int j = returnTypeStartPos;
        do {
            char c;
            if ((c = recordedMethod.charAt(j)) == invokedMethod.charAt(j)) continue;
            return false;
        } while (++j != n);
        return true;
    }

    private boolean isReturnTypeOfRecordedMethodAssignableToReturnTypeOfInvokedMethod(@Nonnull String invokedMethod, @Nonnegative int returnTypeStartPos) {
        String recordedMethod = this.getMethodNameAndDescription();
        Type recordedRT = Type.getType(recordedMethod.substring(returnTypeStartPos));
        Type invokedRT = Type.getType(invokedMethod.substring(returnTypeStartPos));
        return TypeDescriptor.getClassForType(invokedRT).isAssignableFrom(TypeDescriptor.getClassForType(recordedRT));
    }

    public boolean isMatch(@Nonnull ExpectedInvocation other) {
        return this.isMatch(other.instance, other.getClassDesc(), other.getMethodNameAndDescription(), null);
    }

    public boolean isMatch(@Nullable Object replayInstance, @Nonnull String invokedClassDesc, @Nonnull String invokedMethod, @Nullable Map<Object, Object> replacementMap) {
        return this.isMatch(replayInstance, invokedClassDesc, invokedMethod) && (this.arguments.isForConstructor() || !this.matchInstance || this.isEquivalentInstance(replayInstance, replacementMap));
    }

    private boolean isEquivalentInstance(@Nullable Object mockedInstance, @Nullable Map<Object, Object> replacementMap) {
        return mockedInstance == this.instance || mockedInstance != null && this.instance != null && (replacementMap != null && replacementMap.get(mockedInstance) == this.instance || TestRun.getExecutingTest().isInvokedInstanceEquivalentToCapturedInstance(this.instance, mockedInstance));
    }

    public ExpectedInvocation(@Nullable Object mockedInstance, @Nonnull String classDesc, @Nonnull String methodNameAndDesc, @Nonnull Object[] args) {
        this.instance = mockedInstance;
        this.matchInstance = false;
        this.arguments = new InvocationArguments(0, classDesc, methodNameAndDesc, null, args);
        this.invocationCause = null;
    }

    @Nonnull
    public UnexpectedInvocation errorForUnexpectedInvocation() {
        return this.newUnexpectedInvocationWithCause("Unexpected invocation", "Unexpected invocation of" + this);
    }

    @Nonnull
    private UnexpectedInvocation newUnexpectedInvocationWithCause(@Nonnull String titleForCause, @Nonnull String initialMessage) {
        UnexpectedInvocation error = new UnexpectedInvocation(initialMessage);
        this.setErrorAsInvocationCause(titleForCause, error);
        return error;
    }

    private void setErrorAsInvocationCause(@Nonnull String titleForCause, @Nonnull Throwable error) {
        if (this.invocationCause != null) {
            this.invocationCause.defineCause(titleForCause, error);
        }
    }

    @Nonnull
    private MissingInvocation newMissingInvocationWithCause(@Nonnull String titleForCause, @Nonnull String initialMessage) {
        MissingInvocation error = new MissingInvocation(initialMessage);
        this.setErrorAsInvocationCause(titleForCause, error);
        return error;
    }

    @Nonnull
    public MissingInvocation errorForMissingInvocation(@Nonnull List<ExpectedInvocation> nonMatchingInvocations) {
        StringBuilder errorMessage = new StringBuilder(200);
        errorMessage.append("Missing invocation to:\n").append(this);
        this.appendNonMatchingInvocations(errorMessage, nonMatchingInvocations);
        return this.newMissingInvocationWithCause("Missing invocation", errorMessage.toString());
    }

    @Nonnull
    public MissingInvocation errorForMissingInvocations(@Nonnegative int missingInvocations, @Nonnull List<ExpectedInvocation> nonMatchingInvocations) {
        StringBuilder errorMessage = new StringBuilder(200);
        errorMessage.append("Missing ").append(missingInvocations).append(ExpectedInvocation.invocationsTo(missingInvocations)).append(this);
        this.appendNonMatchingInvocations(errorMessage, nonMatchingInvocations);
        return this.newMissingInvocationWithCause("Missing invocations", errorMessage.toString());
    }

    @Nonnull
    private static String invocationsTo(@Nonnegative int invocations) {
        return invocations == 1 ? " invocation to:\n" : " invocations to:\n";
    }

    private void appendNonMatchingInvocations(@Nonnull StringBuilder errorMessage, @Nonnull List<ExpectedInvocation> nonMatchingInvocations) {
        if (!nonMatchingInvocations.isEmpty()) {
            errorMessage.append("\ninstead got:\n");
            String sep = "";
            for (ExpectedInvocation nonMatchingInvocation : nonMatchingInvocations) {
                String invocationDescription = nonMatchingInvocation.toString(this.instance);
                errorMessage.append(sep).append(invocationDescription);
                sep = "\n";
                nonMatchingInvocation.printCause(errorMessage);
            }
        }
    }

    @Nonnull
    public UnexpectedInvocation errorForUnexpectedInvocation(@Nullable Object mock, @Nonnull String invokedClassDesc, @Nonnull String invokedMethod, @Nonnull Object[] replayArgs) {
        StringBuilder message = new StringBuilder(200);
        message.append("Unexpected invocation of:\n");
        message.append(new MethodFormatter(invokedClassDesc, invokedMethod));
        if (replayArgs.length > 0) {
            ArgumentMismatch argumentMismatch = new ArgumentMismatch();
            argumentMismatch.appendFormatted(replayArgs);
            message.append("\n   with arguments: ").append(argumentMismatch);
        }
        if (mock != null) {
            message.append("\n   on instance: ").append(ObjectMethods.objectIdentity(mock));
        }
        message.append("\nwhen was expecting an invocation of:\n").append(this);
        return this.newUnexpectedInvocationWithCause("Unexpected invocation", message.toString());
    }

    @Nonnull
    public UnexpectedInvocation errorForUnexpectedInvocation(@Nonnull Object[] replayArgs) {
        String message = "Unexpected invocation to:\n" + this.toString(replayArgs);
        return this.newUnexpectedInvocationWithCause("Unexpected invocation", message);
    }

    @Nonnull
    public UnexpectedInvocation errorForUnexpectedInvocations(@Nonnull Object[] replayArgs, int numUnexpected) {
        String message = numUnexpected + " unexpected" + ExpectedInvocation.invocationsTo(numUnexpected) + this.toString(replayArgs);
        String titleForCause = numUnexpected == 1 ? "Unexpected invocation" : "Unexpected invocations";
        return this.newUnexpectedInvocationWithCause(titleForCause, message);
    }

    @Nonnull
    public UnexpectedInvocation errorForUnexpectedInvocationBeforeAnother(@Nonnull ExpectedInvocation another) {
        return this.newUnexpectedInvocationWithCause("Unexpected invocation" + this, "Unexpected invocation before" + another);
    }

    @Nonnull
    public UnexpectedInvocation errorForUnexpectedInvocationFoundBeforeAnother() {
        String initialMessage = "Invocation occurred unexpectedly before another" + this;
        return this.newUnexpectedInvocationWithCause("Unexpected invocation", initialMessage);
    }

    @Nonnull
    public UnexpectedInvocation errorForUnexpectedInvocationFoundBeforeAnother(@Nonnull ExpectedInvocation another) {
        String initialMessage = "Another invocation unexpectedly occurred before" + another;
        return this.newUnexpectedInvocationWithCause("Unexpected invocation" + this, initialMessage);
    }

    @Nonnull
    public UnexpectedInvocation errorForUnexpectedInvocationAfterAnother(@Nonnull ExpectedInvocation another) {
        return this.newUnexpectedInvocationWithCause("Unexpected invocation" + this, "Unexpected invocation after" + another);
    }

    @Nonnull
    public String toString() {
        return this.toString((Object)null);
    }

    @Nonnull
    public String toString(@Nullable Object otherInstance) {
        String desc = this.arguments.toString();
        if (this.instance != otherInstance && this.instance != null) {
            desc = desc + "\n   on mock instance: " + ObjectMethods.objectIdentity(this.instance);
        }
        return desc;
    }

    @Nonnull
    String toString(@Nonnull Object[] actualInvocationArguments) {
        Object[] invocationArgs = this.arguments.getValues();
        List<ArgumentMatcher<?>> matchers = this.arguments.getMatchers();
        this.arguments.setValues(actualInvocationArguments);
        this.arguments.setMatchers(null);
        String description = this.toString();
        this.arguments.setMatchers(matchers);
        this.arguments.setValues(invocationArgs);
        return description;
    }

    public void printCause(@Nonnull Appendable errorMessage) {
        if (this.invocationCause != null) {
            try {
                errorMessage.append('\n');
            }
            catch (IOException iOException) {
                // empty catch block
            }
            StackTrace st = new StackTrace((Throwable)((Object)this.invocationCause));
            st.filter();
            st.print(errorMessage);
        }
    }

    @Nullable
    public Error assertThatArgumentsMatch(@Nonnull Object[] replayArgs, @Nonnull Map<Object, Object> instanceMap) {
        return this.arguments.assertMatch(replayArgs, instanceMap);
    }

    @Nullable
    public Object getDefaultValueForReturnType() {
        if (this.defaultReturnValue == UNDEFINED_DEFAULT_RETURN) {
            Class<?> resolvedReturnType = this.getReturnTypeAsResolvedFromClassArgument();
            if (resolvedReturnType != null) {
                this.defaultReturnValue = DefaultValues.computeForType(resolvedReturnType);
                if (this.defaultReturnValue == null) {
                    String returnTypeDesc = 'L' + resolvedReturnType.getName().replace('.', '/') + ';';
                    String mockedTypeDesc = this.getClassDesc();
                    this.defaultReturnValue = MockedTypeCascade.getMock(mockedTypeDesc, this.arguments.methodNameAndDesc, this.instance, returnTypeDesc, resolvedReturnType);
                }
                return this.defaultReturnValue;
            }
            String returnTypeDesc = DefaultValues.getReturnTypeDesc(this.arguments.methodNameAndDesc);
            this.defaultReturnValue = DefaultValues.computeForType(returnTypeDesc);
            if (this.defaultReturnValue == null) {
                String mockedTypeDesc = this.getClassDesc();
                this.defaultReturnValue = MockedTypeCascade.getMock(mockedTypeDesc, this.arguments.methodNameAndDesc, this.instance, returnTypeDesc, this.arguments.genericSignature);
            }
        }
        return this.defaultReturnValue;
    }

    @Nullable
    private Class<?> getReturnTypeAsResolvedFromClassArgument() {
        int returnTypePos;
        char c;
        String genericSignature = this.arguments.genericSignature;
        if (genericSignature != null && (c = genericSignature.charAt(returnTypePos = genericSignature.lastIndexOf(41) + 1)) == 'T') {
            for (Object arg : this.arguments.getValues()) {
                if (!(arg instanceof Class)) continue;
                return (Class)arg;
            }
        }
        return null;
    }

    public void copyDefaultReturnValue(@Nonnull ExpectedInvocation other) {
        this.defaultReturnValue = other.defaultReturnValue;
    }
}

