/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.ClassReader;
import mockit.external.asm.Type;
import mockit.internal.BaseClassModifier;
import mockit.internal.ClassFile;
import mockit.internal.RedefinitionEngine;
import mockit.internal.capturing.CaptureOfImplementations;
import mockit.internal.expectations.mocking.ExpectationsModifier;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.startup.Startup;
import mockit.internal.state.TestRun;
import mockit.internal.util.FieldReflection;
import mockit.internal.util.Utilities;

public class CaptureOfNewInstances
extends CaptureOfImplementations<MockedType> {
    @Nonnull
    private final Map<Class<?>, List<Capture>> baseTypeToCaptures = new HashMap();
    @Nonnull
    private final List<Class<?>> partiallyMockedBaseTypes = new ArrayList();

    CaptureOfNewInstances() {
    }

    @Nonnull
    protected final Collection<List<Capture>> getCapturesForAllBaseTypes() {
        return this.baseTypeToCaptures.values();
    }

    void useDynamicMocking(@Nonnull Class<?> baseType) {
        this.partiallyMockedBaseTypes.add(baseType);
        List<Class<?>> mockedClasses = TestRun.mockFixture().getMockedClasses();
        for (Class<?> mockedClass : mockedClasses) {
            if (!baseType.isAssignableFrom(mockedClass) || mockedClass == baseType && baseType.isInterface()) continue;
            CaptureOfNewInstances.redefineClassForDynamicPartialMocking(baseType, mockedClass);
        }
    }

    private static void redefineClassForDynamicPartialMocking(@Nonnull Class<?> baseType, @Nonnull Class<?> mockedClass) {
        ClassReader classReader = ClassFile.createReaderOrGetFromCache(mockedClass);
        ExpectationsModifier modifier = CaptureOfNewInstances.newModifier(mockedClass.getClassLoader(), classReader, baseType, null);
        modifier.useDynamicMocking(true);
        classReader.accept(modifier, 4);
        byte[] modifiedClassfile = modifier.toByteArray();
        Startup.redefineMethods(mockedClass, modifiedClassfile);
    }

    @Nonnull
    private static ExpectationsModifier newModifier(@Nullable ClassLoader cl, @Nonnull ClassReader cr, @Nonnull Class<?> baseType, @Nullable MockedType typeMetadata) {
        ExpectationsModifier modifier = new ExpectationsModifier(cl, cr, typeMetadata);
        modifier.setClassNameForCapturedInstanceMethods(Type.getInternalName(baseType));
        return modifier;
    }

    @Override
    @Nonnull
    protected final BaseClassModifier createModifier(@Nullable ClassLoader cl, @Nonnull ClassReader cr, @Nonnull Class<?> baseType, @Nullable MockedType typeMetadata) {
        ExpectationsModifier modifier = CaptureOfNewInstances.newModifier(cl, cr, baseType, typeMetadata);
        if (this.partiallyMockedBaseTypes.contains(baseType)) {
            modifier.useDynamicMocking(true);
        }
        return modifier;
    }

    @Override
    protected final void redefineClass(@Nonnull Class<?> realClass, @Nonnull byte[] modifiedClass) {
        new RedefinitionEngine(realClass).redefineMethodsWhileRegisteringTheClass(modifiedClass);
    }

    final void registerCaptureOfNewInstances(@Nonnull MockedType typeMetadata, @Nullable Object mockInstance) {
        List<Capture> captures;
        Class<?> baseType = typeMetadata.getClassType();
        if (!typeMetadata.isFinalFieldOrParameter()) {
            this.makeSureAllSubtypesAreModified(typeMetadata);
        }
        if ((captures = this.baseTypeToCaptures.get(baseType)) == null) {
            captures = new ArrayList<Capture>();
            this.baseTypeToCaptures.put(baseType, captures);
        }
        captures.add(new Capture(typeMetadata, mockInstance));
    }

    final void makeSureAllSubtypesAreModified(@Nonnull MockedType typeMetadata) {
        Class<?> baseType = typeMetadata.getClassType();
        this.makeSureAllSubtypesAreModified(baseType, typeMetadata.fieldFromTestClass, typeMetadata);
    }

    public final boolean captureNewInstance(@Nullable Object fieldOwner, @Nonnull Object mock) {
        boolean constructorModifiedForCaptureOnly;
        Class<?> mockedClass = mock.getClass();
        List<Capture> captures = this.baseTypeToCaptures.get(mockedClass);
        boolean bl = constructorModifiedForCaptureOnly = captures == null;
        if (constructorModifiedForCaptureOnly && (captures = this.findCaptures(mockedClass)) == null) {
            return false;
        }
        Capture captureFound = CaptureOfNewInstances.findCapture(fieldOwner, mock, captures);
        if (captureFound != null) {
            if (captureFound.typeMetadata.injectable) {
                TestRun.getExecutingTest().addCapturedInstanceForInjectableMock(captureFound.originalMockInstance, mock);
                constructorModifiedForCaptureOnly = true;
            } else {
                TestRun.getExecutingTest().addCapturedInstance(captureFound.originalMockInstance, mock);
            }
        }
        return constructorModifiedForCaptureOnly;
    }

    @Nullable
    private List<Capture> findCaptures(@Nonnull Class<?> mockedClass) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = mockedClass.getInterfaces()) {
            List<Capture> found = this.baseTypeToCaptures.get(anInterface);
            if (found == null) continue;
            return found;
        }
        Class<?> superclass = mockedClass.getSuperclass();
        if (superclass == Object.class) {
            return null;
        }
        List<Capture> found = this.baseTypeToCaptures.get(superclass);
        return found != null ? found : this.findCaptures(superclass);
    }

    @Nullable
    private static Capture findCapture(@Nullable Object fieldOwner, @Nonnull Object mock, @Nonnull List<Capture> captures) {
        for (Capture capture : captures) {
            if (capture.isInstanceAlreadyCaptured(mock)) break;
            if (!capture.captureInstance(fieldOwner, mock)) continue;
            return capture;
        }
        return null;
    }

    public final void cleanUp() {
        this.baseTypeToCaptures.clear();
        this.partiallyMockedBaseTypes.clear();
    }

    static final class Capture {
        @Nonnull
        final MockedType typeMetadata;
        @Nullable
        private Object originalMockInstance;
        @Nonnull
        private final List<Object> instancesCaptured;

        private Capture(@Nonnull MockedType typeMetadata, @Nullable Object originalMockInstance) {
            this.typeMetadata = typeMetadata;
            this.originalMockInstance = originalMockInstance;
            this.instancesCaptured = new ArrayList<Object>(4);
        }

        private boolean isInstanceAlreadyCaptured(@Nonnull Object mock) {
            return Utilities.containsReference(this.instancesCaptured, mock);
        }

        private boolean captureInstance(@Nullable Object fieldOwner, @Nonnull Object instance) {
            if (this.instancesCaptured.size() < this.typeMetadata.getMaxInstancesToCapture()) {
                if (fieldOwner != null && this.typeMetadata.field != null && this.originalMockInstance == null) {
                    this.originalMockInstance = FieldReflection.getFieldValue(this.typeMetadata.field, fieldOwner);
                }
                this.instancesCaptured.add(instance);
                return true;
            }
            return false;
        }

        void reset() {
            this.originalMockInstance = null;
            this.instancesCaptured.clear();
        }
    }
}

